/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.yahoo.elide.modelconfig.jsonformats.ElideNameFormatAttr;
import java.util.Locale;
import java.util.regex.Pattern;

public class ElideNamespaceNameFormatAttr
extends AbstractFormatAttribute {
    public static final Pattern NAME_FORMAT_REGEX = ElideNameFormatAttr.NAME_FORMAT_REGEX;
    public static final String FORMAT_NAME = "elideNamespaceName";
    public static final String FORMAT_KEY = "elideNamespaceName.error.format";
    public static final String FORMAT_ADDITIONAL_KEY = "elideNamespaceName.error.additional";
    public static final String FORMAT_KEY_MSG = "Name [%s] is not allowed. Name must start with an alphabetic character and can include alaphabets, numbers and '_' only.";
    public static final String FORMAT_ADDITIONAL_KEY_MSG = "Name [%s] clashes with the 'default' namespace. Either change the case or pick a different namespace name.";
    public static final String DEFAULT_NAME = "default";

    public ElideNamespaceNameFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!NAME_FORMAT_REGEX.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, FORMAT_KEY).putArgument("value", (Object)input));
        }
        if (!input.equals(DEFAULT_NAME) && input.toLowerCase(Locale.ENGLISH).equals(DEFAULT_NAME)) {
            report.error(this.newMsg(data, bundle, FORMAT_ADDITIONAL_KEY).putArgument("value", (Object)input));
        }
    }
}

