/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public class ElideJoinTypeFormatAttr
extends AbstractFormatAttribute {
    private static final Pattern JOIN_TYPE_PATTERN = Pattern.compile("^(?i)(left|inner|full|cross)$");
    public static final String FORMAT_NAME = "elideJoinType";
    public static final String TYPE_KEY = "elideJoinType.error.enum";
    public static final String TYPE_MSG = "Join type [%s] is not allowed. Supported value is one of [left, inner, full, cross].";

    public ElideJoinTypeFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!JOIN_TYPE_PATTERN.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, TYPE_KEY).putArgument("value", (Object)input));
        }
    }
}

