/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public class ElideJDBCUrlFormatAttr
extends AbstractFormatAttribute {
    public static final String FORMAT_NAME = "elideJdbcUrl";
    public static final String FORMAT_KEY = "elideJdbcUrl.error.format";
    public static final String FORMAT_MSG = "Input value [%s] is not a valid JDBC url, it must start with 'jdbc:'.";

    public ElideJDBCUrlFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!input.startsWith("jdbc:")) {
            report.error(this.newMsg(data, bundle, FORMAT_KEY).putArgument("value", (Object)input));
        }
    }
}

