/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public class ElideGrainTypeFormatAttr
extends AbstractFormatAttribute {
    private static final Pattern GRAIN_TYPE_PATTERN = Pattern.compile("^(?i)(Second|Minute|Hour|Day|IsoWeek|Week|Month|Quarter|Year)$");
    public static final String FORMAT_NAME = "elideGrainType";
    public static final String TYPE_KEY = "elideGrainType.error.enum";
    public static final String TYPE_MSG = "Grain type [%s] is not allowed. Supported value is one of [Second, Minute, Hour, Day, IsoWeek, Week, Month, Quarter, Year].";

    public ElideGrainTypeFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!GRAIN_TYPE_PATTERN.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, TYPE_KEY).putArgument("value", (Object)input));
        }
    }
}

