/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public class ElideFieldTypeFormatAttr
extends AbstractFormatAttribute {
    public static final Pattern FIELD_TYPE_PATTERN = Pattern.compile("^(?i)(Integer|Decimal|Money|Text|Coordinate|Boolean|Enum_Text|Enum_Ordinal)$");
    public static final String FORMAT_NAME = "elideFieldType";
    public static final String TYPE_KEY = "elideFieldType.error.enum";
    public static final String TYPE_MSG = "Field type [%s] is not allowed. Supported value is one of [Integer, Decimal, Money, Text, Coordinate, Boolean, Enum_Text, Enum_Ordinal].";

    public ElideFieldTypeFormatAttr() {
        this(FORMAT_NAME);
    }

    public ElideFieldTypeFormatAttr(String formatName) {
        super(formatName, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!FIELD_TYPE_PATTERN.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, TYPE_KEY).putArgument("value", (Object)input));
        }
    }
}

