/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ElideFieldNameFormatAttr
extends AbstractFormatAttribute {
    private static final Pattern FIELD_NAME_FORMAT_REGEX = Pattern.compile("^[a-z][0-9A-Za-z_]*$");
    private static final Set<String> RESERVED_KEYWORDS_FOR_COLUMN_NAME = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    public static final String FORMAT_NAME = "elideFieldName";
    public static final String NAME_KEY = "elideFieldName.error.name";
    public static final String NAME_MSG;
    public static final String FORMAT_KEY = "elideFieldName.error.format";
    public static final String FORMAT_MSG = "Field name [%s] is not allowed. Field name must start with lower case alphabet and can include alaphabets, numbers and '_' only.";

    public ElideFieldNameFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!FIELD_NAME_FORMAT_REGEX.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, FORMAT_KEY).putArgument("value", (Object)input));
        }
        if (RESERVED_KEYWORDS_FOR_COLUMN_NAME.contains(input)) {
            report.error(this.newMsg(data, bundle, NAME_KEY).putArgument("value", (Object)input));
        }
    }

    static {
        RESERVED_KEYWORDS_FOR_COLUMN_NAME.add("id");
        RESERVED_KEYWORDS_FOR_COLUMN_NAME.add("sql");
        NAME_MSG = "Field name [%s] is not allowed. Field name cannot be one of " + RESERVED_KEYWORDS_FOR_COLUMN_NAME;
    }
}

