/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.yahoo.elide.modelconfig.Config;
import com.yahoo.elide.modelconfig.DraftV4LibraryWithElideFormatAttr;
import com.yahoo.elide.modelconfig.DynamicConfigHelpers;
import com.yahoo.elide.modelconfig.MessageBundleWithElideMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigSchemaValidator.class);
    private JsonSchema tableSchema;
    private JsonSchema securitySchema;
    private JsonSchema variableSchema;
    private JsonSchema dbConfigSchema;
    private JsonSchema namespaceConfigSchema;
    private static String NEWLINE = System.lineSeparator();

    public DynamicConfigSchemaValidator() {
        Library library = new DraftV4LibraryWithElideFormatAttr().getLibrary();
        MessageBundle bundle = new MessageBundleWithElideMessages().getMsgBundle();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).setValidationMessages(bundle).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        this.tableSchema = DynamicConfigSchemaValidator.loadSchema(factory, Config.TABLE.getConfigSchema());
        this.securitySchema = DynamicConfigSchemaValidator.loadSchema(factory, Config.SECURITY.getConfigSchema());
        this.variableSchema = DynamicConfigSchemaValidator.loadSchema(factory, Config.MODELVARIABLE.getConfigSchema());
        this.dbConfigSchema = DynamicConfigSchemaValidator.loadSchema(factory, Config.SQLDBConfig.getConfigSchema());
        this.namespaceConfigSchema = DynamicConfigSchemaValidator.loadSchema(factory, Config.NAMESPACEConfig.getConfigSchema());
    }

    public boolean verifySchema(Config configType, String jsonConfig, String fileName) throws IOException, ProcessingException {
        ProcessingReport results = null;
        switch (configType) {
            case TABLE: {
                results = this.tableSchema.validate(new ObjectMapper().readTree(jsonConfig), true);
                break;
            }
            case SECURITY: {
                results = this.securitySchema.validate(new ObjectMapper().readTree(jsonConfig), true);
                break;
            }
            case MODELVARIABLE: 
            case DBVARIABLE: {
                results = this.variableSchema.validate(new ObjectMapper().readTree(jsonConfig), true);
                break;
            }
            case SQLDBConfig: {
                results = this.dbConfigSchema.validate(new ObjectMapper().readTree(jsonConfig), true);
                break;
            }
            case NAMESPACEConfig: {
                results = this.namespaceConfigSchema.validate(new ObjectMapper().readTree(jsonConfig), true);
                break;
            }
            default: {
                log.error("Not a valid config type :" + configType);
            }
        }
        if (results == null || !results.isSuccess()) {
            throw new IllegalStateException("Schema validation failed for: " + fileName + DynamicConfigSchemaValidator.getErrorMessages(results));
        }
        return true;
    }

    private static String getErrorMessages(ProcessingReport report) {
        if (report == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        report.forEach(msg -> DynamicConfigSchemaValidator.addEmbeddedMessages(msg.asJson(), list, 0));
        return NEWLINE + String.join((CharSequence)NEWLINE, list);
    }

    private static void addEmbeddedMessages(JsonNode root, List<String> list, int depth) {
        String level;
        if (root.has("level") && root.has("message") && ((level = root.get("level").asText()).equalsIgnoreCase(LogLevel.ERROR.name()) || level.equalsIgnoreCase(LogLevel.FATAL.name()))) {
            String schemaPointer;
            Object msg = root.get("message").asText();
            String instancePointer = DynamicConfigSchemaValidator.extractPointer(root, "instance");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{instancePointer, schemaPointer = DynamicConfigSchemaValidator.extractPointer(root, "schema")})) {
                msg = "Instance[" + instancePointer + "] failed to validate against schema[" + schemaPointer + "]. " + (String)msg;
            }
            list.add((String)(depth == 0 ? "[ERROR]" + NEWLINE + (String)msg : String.format("%" + (4 * depth + ((String)msg).length()) + "s", msg)));
            if (root.has("reports")) {
                Iterator fields = root.get("reports").fields();
                while (fields.hasNext()) {
                    ArrayNode arrayNode = (ArrayNode)((Map.Entry)fields.next()).getValue();
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        DynamicConfigSchemaValidator.addEmbeddedMessages(arrayNode.get(i), list, depth + 1);
                    }
                }
            }
        }
    }

    private static String extractPointer(JsonNode root, String fieldName) {
        JsonNode node;
        String pointer = null;
        if (root.has(fieldName) && (node = root.get(fieldName)).has("pointer")) {
            pointer = node.get("pointer").asText();
        }
        return pointer;
    }

    private static JsonSchema loadSchema(JsonSchemaFactory factory, String resource) {
        JsonSchema jsonSchema;
        block8: {
            InputStream is = DynamicConfigHelpers.class.getResourceAsStream(resource);
            try {
                jsonSchema = factory.getJsonSchema(new ObjectMapper().readTree(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException | IOException e) {
                    log.error("Error loading schema file " + resource + " to verify");
                    throw new IllegalStateException(e.getMessage());
                }
            }
            is.close();
        }
        return jsonSchema;
    }
}

