/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.yahoo.elide.modelconfig.Config;
import com.yahoo.elide.modelconfig.DynamicConfigSchemaValidator;
import com.yahoo.elide.modelconfig.model.ElideDBConfig;
import com.yahoo.elide.modelconfig.model.ElideNamespaceConfig;
import com.yahoo.elide.modelconfig.model.ElideSecurityConfig;
import com.yahoo.elide.modelconfig.model.ElideTableConfig;
import com.yahoo.elide.modelconfig.parser.handlebars.HandlebarsHydrator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hjson.JsonValue;
import org.hjson.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigHelpers {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigHelpers.class);

    public static String formatFilePath(String basePath) {
        if (StringUtils.isNotBlank((CharSequence)basePath) && !((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        return basePath;
    }

    public static Map<String, Object> stringToVariablesPojo(String fileName, String config, DynamicConfigSchemaValidator schemaValidator) throws IOException {
        Map<String, Object> variables = new HashMap<String, Object>();
        String jsonConfig = DynamicConfigHelpers.hjsonToJson(config);
        try {
            if (schemaValidator.verifySchema(Config.MODELVARIABLE, jsonConfig, fileName)) {
                variables = DynamicConfigHelpers.getModelPojo(jsonConfig, Map.class);
            }
        }
        catch (ProcessingException e) {
            log.error("Error Validating Variable config : " + e.getMessage());
            throw new IOException(e);
        }
        return variables;
    }

    public static ElideTableConfig stringToElideTablePojo(String fileName, String content, Map<String, Object> variables, DynamicConfigSchemaValidator schemaValidator) throws IOException {
        ElideTableConfig table = new ElideTableConfig();
        String jsonConfig = DynamicConfigHelpers.hjsonToJson(DynamicConfigHelpers.resolveVariables(content, variables));
        try {
            if (schemaValidator.verifySchema(Config.TABLE, jsonConfig, fileName)) {
                table = DynamicConfigHelpers.getModelPojo(jsonConfig, ElideTableConfig.class);
            }
        }
        catch (ProcessingException e) {
            log.error("Error Validating Table config : " + e.getMessage());
            throw new IOException(e);
        }
        return table;
    }

    public static ElideDBConfig stringToElideDBConfigPojo(String fileName, String content, Map<String, Object> variables, DynamicConfigSchemaValidator schemaValidator) throws IOException {
        ElideDBConfig dbconfig = new ElideDBConfig();
        String jsonConfig = DynamicConfigHelpers.hjsonToJson(DynamicConfigHelpers.resolveVariables(content, variables));
        try {
            if (schemaValidator.verifySchema(Config.SQLDBConfig, jsonConfig, fileName)) {
                dbconfig = DynamicConfigHelpers.getModelPojo(jsonConfig, ElideDBConfig.class);
            }
        }
        catch (ProcessingException e) {
            log.error("Error Validating DB config : " + e.getMessage());
            throw new IOException(e);
        }
        return dbconfig;
    }

    public static ElideNamespaceConfig stringToElideNamespaceConfigPojo(String fileName, String content, Map<String, Object> variables, DynamicConfigSchemaValidator schemaValidator) throws IOException {
        ElideNamespaceConfig namespaceconfig = new ElideNamespaceConfig();
        String jsonConfig = DynamicConfigHelpers.hjsonToJson(DynamicConfigHelpers.resolveVariables(content, variables));
        try {
            if (schemaValidator.verifySchema(Config.NAMESPACEConfig, jsonConfig, fileName)) {
                namespaceconfig = DynamicConfigHelpers.getModelPojo(jsonConfig, ElideNamespaceConfig.class);
            }
        }
        catch (ProcessingException e) {
            log.error("Error Validating DB config : " + e.getMessage());
            throw new IOException(e);
        }
        return namespaceconfig;
    }

    public static ElideSecurityConfig stringToElideSecurityPojo(String fileName, String content, Map<String, Object> variables, DynamicConfigSchemaValidator schemaValidator) throws IOException {
        String jsonConfig = DynamicConfigHelpers.hjsonToJson(DynamicConfigHelpers.resolveVariables(content, variables));
        try {
            if (schemaValidator.verifySchema(Config.SECURITY, jsonConfig, fileName)) {
                return DynamicConfigHelpers.getModelPojo(jsonConfig, ElideSecurityConfig.class);
            }
        }
        catch (ProcessingException e) {
            log.error("Error Validating Security config : " + e.getMessage());
            throw new IOException(e);
        }
        return null;
    }

    public static String resolveVariables(String jsonConfig, Map<String, Object> variables) throws IOException {
        HandlebarsHydrator hydrator = new HandlebarsHydrator();
        return hydrator.hydrateConfigTemplate(jsonConfig, variables);
    }

    private static String hjsonToJson(String hjson) {
        try {
            return JsonValue.readHjson((String)hjson).toString();
        }
        catch (ParseException e) {
            throw new IllegalStateException("Invalid Hjson Syntax: " + e.getMessage());
        }
    }

    private static <T> T getModelPojo(String jsonConfig, Class<T> configPojo) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        return (T)objectMapper.readValue(jsonConfig, configPojo);
    }
}

