/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.websocket.protocol;

import jakarta.websocket.CloseReason;

public class WebSocketCloseReasons {
    public static final CloseReason CONNECTION_TIMEOUT = CloseCode.CONNECTION_TIMEOUT.toReason("Connection initialisation timeout");
    public static final CloseReason MULTIPLE_INIT = CloseCode.MULTIPLE_INIT.toReason("Too many initialisation requests");
    public static final CloseReason UNAUTHORIZED = CloseCode.UNAUTHORIZED.toReason("Unauthorized");
    public static final CloseReason INVALID_MESSAGE = CloseCode.INVALID_MESSAGE.toReason("Invalid message");
    public static final CloseReason INTERNAL_ERROR = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Internal Error");
    public static final CloseReason NORMAL_CLOSE = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Normal Closure");
    public static final CloseReason MAX_SUBSCRIPTIONS = CloseCode.MAX_SUBSCRIPTIONS.toReason("Exceeded max subscriptions");

    public static CloseReason.CloseCode createCloseCode(final int code) {
        return new CloseReason.CloseCode(){

            public int getCode() {
                return code;
            }
        };
    }

    public static enum CloseCode {
        CONNECTION_TIMEOUT(4408),
        MULTIPLE_INIT(4429),
        UNAUTHORIZED(4401),
        INVALID_MESSAGE(4400),
        MAX_SUBSCRIPTIONS(4300),
        DUPLICATE_ID(4409);

        private int code;

        private CloseCode(int code) {
            this.code = code;
        }

        public CloseReason toReason(String reason) {
            return new CloseReason(WebSocketCloseReasons.createCloseCode(this.code), reason);
        }

        public int getCode() {
            return this.code;
        }
    }
}

