/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions.websocket;

import com.yahoo.elide.Elide;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.BasicApiVersionValidator;
import com.yahoo.elide.core.request.route.FlexibleRouteResolver;
import com.yahoo.elide.core.request.route.NullRouteResolver;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.DefaultClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.subscriptions.SubscriptionDataFetcher;
import com.yahoo.elide.graphql.subscriptions.SubscriptionModelBuilder;
import com.yahoo.elide.graphql.subscriptions.websocket.ConnectionInfo;
import com.yahoo.elide.graphql.subscriptions.websocket.SessionHandler;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.WebSocketCloseReasons;
import graphql.GraphQL;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.schema.GraphQLSchema;
import graphql.schema.validation.InvalidSchemaException;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionWebSocket
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionWebSocket.class);
    public static final String SUBPROTOCOL_GRAPHQL_TRANSPORT_WS = "graphql-transport-ws";
    public static final List<String> SUPPORTED_WEBSOCKET_SUBPROTOCOLS = List.of("graphql-transport-ws");
    private Elide elide;
    private ExecutorService executorService;
    private Duration connectionTimeout;
    private int maxSubscriptions;
    private UserFactory userFactory;
    private Duration maxIdleTimeout;
    private int maxMessageSize;
    private boolean sendPingOnSubscribe;
    private DataFetcherExceptionHandler dataFetcherExceptionHandler;
    private RouteResolver routeResolver;
    private final Map<String, GraphQL> apis = new HashMap<String, GraphQL>();
    private final ConcurrentMap<Session, SessionHandler> openSessions = new ConcurrentHashMap<Session, SessionHandler>();
    public static final UserFactory DEFAULT_USER_FACTORY = session -> new User(session.getUserPrincipal());

    protected SubscriptionWebSocket(Elide elide, ExecutorService executorService, Duration connectionTimeout, int maxSubscriptions, UserFactory userFactory, Duration maxIdleTimeout, int maxMessageSize, boolean sendPingOnSubscribe, DataFetcherExceptionHandler dataFetcherExceptionHandler, RouteResolver routeResolver) {
        this.elide = elide;
        this.executorService = executorService;
        this.connectionTimeout = connectionTimeout;
        this.maxSubscriptions = maxSubscriptions;
        this.userFactory = userFactory;
        this.sendPingOnSubscribe = sendPingOnSubscribe;
        this.maxIdleTimeout = maxIdleTimeout;
        this.maxMessageSize = maxMessageSize;
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
        this.routeResolver = routeResolver;
        EntityDictionary dictionary = elide.getElideSettings().getEntityDictionary();
        for (String apiVersion : dictionary.getApiVersions()) {
            NonEntityDictionary nonEntityDictionary = new NonEntityDictionary((ClassScanner)new DefaultClassScanner(), CoerceUtil::lookup);
            SubscriptionModelBuilder builder = new SubscriptionModelBuilder(dictionary, nonEntityDictionary, new SubscriptionDataFetcher(nonEntityDictionary), apiVersion);
            try {
                GraphQL api = GraphQL.newGraphQL((GraphQLSchema)builder.build()).defaultDataFetcherExceptionHandler(this.dataFetcherExceptionHandler).queryExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy(this.dataFetcherExceptionHandler)).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy(this.dataFetcherExceptionHandler)).build();
                this.apis.put(apiVersion, api);
            }
            catch (InvalidSchemaException e) {
                this.apis.put(apiVersion, null);
            }
        }
        if (this.routeResolver == null) {
            Set apiVersions = elide.getElideSettings().getEntityDictionary().getApiVersions();
            this.routeResolver = apiVersions.size() == 1 && apiVersions.contains("") ? new NullRouteResolver() : new FlexibleRouteResolver((ApiVersionValidator)new BasicApiVersionValidator(), () -> "");
        }
    }

    public void onOpen(final Session session, EndpointConfig config) {
        log.debug("Session Opening: {}", (Object)session.getId());
        SessionHandler subscriptionSession = this.createSessionHandler(session);
        session.setMaxIdleTimeout(this.maxIdleTimeout.toMillis());
        session.setMaxTextMessageBufferSize(this.maxMessageSize);
        session.setMaxBinaryMessageBufferSize(this.maxMessageSize);
        this.openSessions.put(session, subscriptionSession);
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                SubscriptionWebSocket.this.onMessage(session, message);
            }
        });
    }

    public void onMessage(Session session, String message) {
        log.debug("Session Message: {} {}", (Object)session.getId(), (Object)message);
        SessionHandler handler = this.findSession(session);
        if (handler == null) {
            throw new IllegalStateException("Cannot locate session: " + session.getId());
        }
        handler.handleRequest(message);
    }

    public void onClose(Session session, CloseReason closeReason) {
        log.debug("Session Closing: {}", (Object)session.getId());
        SessionHandler handler = this.findSession(session);
        if (handler != null) {
            handler.safeClose(WebSocketCloseReasons.NORMAL_CLOSE);
            this.openSessions.remove(session);
        }
    }

    public void onError(Session session, Throwable throwable) {
        log.error("Session Error: {} {}", (Object)session.getId(), (Object)throwable.getMessage());
        SessionHandler handler = this.findSession(session);
        if (handler != null) {
            handler.safeClose(WebSocketCloseReasons.INTERNAL_ERROR);
            this.openSessions.remove(session);
        }
    }

    private SessionHandler findSession(Session wrappedSession) {
        SessionHandler sessionHandler = this.openSessions.getOrDefault(wrappedSession, null);
        String message = "Unable to locate active session: " + wrappedSession.getId();
        if (sessionHandler == null) {
            log.error(message);
        }
        return sessionHandler;
    }

    protected SessionHandler createSessionHandler(Session session) {
        User user = this.userFactory.create(session);
        String path = (String)session.getPathParameters().get("path");
        if (path == null) {
            path = "";
        }
        String baseUrl = this.getBaseUrl(session);
        if (!path.isBlank() && baseUrl.endsWith(path)) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - path.length());
        }
        LinkedHashMap headers = new LinkedHashMap(session.getRequestParameterMap());
        Object v = session.getUserProperties().get("headers");
        if (v instanceof Map) {
            Map handshakeHeaders = (Map)v;
            headers.putAll(handshakeHeaders);
        }
        Route route = this.routeResolver.resolve("application/json", baseUrl, path, headers, session.getRequestParameterMap());
        String apiVersion = route.getApiVersion();
        return new SessionHandler(session, this.elide.getDataStore(), this.elide, this.apis.get(apiVersion), this.connectionTimeout, this.maxSubscriptions, ConnectionInfo.builder().user(user).route(route).build(), this.sendPingOnSubscribe, this.executorService);
    }

    protected String getBaseUrl(Session session) {
        String baseUrl = "";
        Object v = session.getUserProperties().get("requestURI");
        if (v instanceof URI) {
            URI requestUri = (URI)v;
            String scheme = requestUri.getScheme();
            scheme = "ws".equals(scheme) ? "http" : "https";
            try {
                baseUrl = new URI(scheme, requestUri.getAuthority(), requestUri.getPath(), null, null).toString();
            }
            catch (URISyntaxException e) {
                baseUrl = "";
            }
        }
        return baseUrl;
    }

    private static Duration $default$connectionTimeout() {
        return Duration.ofMillis(5000L);
    }

    private static int $default$maxSubscriptions() {
        return 30;
    }

    private static UserFactory $default$userFactory() {
        return DEFAULT_USER_FACTORY;
    }

    private static Duration $default$maxIdleTimeout() {
        return Duration.ofMillis(300000L);
    }

    private static int $default$maxMessageSize() {
        return 10000;
    }

    private static boolean $default$sendPingOnSubscribe() {
        return false;
    }

    private static DataFetcherExceptionHandler $default$dataFetcherExceptionHandler() {
        return new SimpleDataFetcherExceptionHandler();
    }

    private static RouteResolver $default$routeResolver() {
        return null;
    }

    public static SubscriptionWebSocketBuilder builder() {
        return new SubscriptionWebSocketBuilder();
    }

    @FunctionalInterface
    public static interface UserFactory {
        public User create(Session var1);
    }

    public static class SubscriptionWebSocketBuilder {
        private Elide elide;
        private ExecutorService executorService;
        private boolean connectionTimeout$set;
        private Duration connectionTimeout$value;
        private boolean maxSubscriptions$set;
        private int maxSubscriptions$value;
        private boolean userFactory$set;
        private UserFactory userFactory$value;
        private boolean maxIdleTimeout$set;
        private Duration maxIdleTimeout$value;
        private boolean maxMessageSize$set;
        private int maxMessageSize$value;
        private boolean sendPingOnSubscribe$set;
        private boolean sendPingOnSubscribe$value;
        private boolean dataFetcherExceptionHandler$set;
        private DataFetcherExceptionHandler dataFetcherExceptionHandler$value;
        private boolean routeResolver$set;
        private RouteResolver routeResolver$value;

        SubscriptionWebSocketBuilder() {
        }

        public SubscriptionWebSocketBuilder elide(Elide elide) {
            this.elide = elide;
            return this;
        }

        public SubscriptionWebSocketBuilder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SubscriptionWebSocketBuilder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout$value = connectionTimeout;
            this.connectionTimeout$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxSubscriptions(int maxSubscriptions) {
            this.maxSubscriptions$value = maxSubscriptions;
            this.maxSubscriptions$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder userFactory(UserFactory userFactory) {
            this.userFactory$value = userFactory;
            this.userFactory$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxIdleTimeout(Duration maxIdleTimeout) {
            this.maxIdleTimeout$value = maxIdleTimeout;
            this.maxIdleTimeout$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize$value = maxMessageSize;
            this.maxMessageSize$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder sendPingOnSubscribe(boolean sendPingOnSubscribe) {
            this.sendPingOnSubscribe$value = sendPingOnSubscribe;
            this.sendPingOnSubscribe$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder dataFetcherExceptionHandler(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
            this.dataFetcherExceptionHandler$value = dataFetcherExceptionHandler;
            this.dataFetcherExceptionHandler$set = true;
            return this;
        }

        public SubscriptionWebSocketBuilder routeResolver(RouteResolver routeResolver) {
            this.routeResolver$value = routeResolver;
            this.routeResolver$set = true;
            return this;
        }

        public SubscriptionWebSocket build() {
            Duration connectionTimeout$value = this.connectionTimeout$value;
            if (!this.connectionTimeout$set) {
                connectionTimeout$value = SubscriptionWebSocket.$default$connectionTimeout();
            }
            int maxSubscriptions$value = this.maxSubscriptions$value;
            if (!this.maxSubscriptions$set) {
                maxSubscriptions$value = SubscriptionWebSocket.$default$maxSubscriptions();
            }
            UserFactory userFactory$value = this.userFactory$value;
            if (!this.userFactory$set) {
                userFactory$value = SubscriptionWebSocket.$default$userFactory();
            }
            Duration maxIdleTimeout$value = this.maxIdleTimeout$value;
            if (!this.maxIdleTimeout$set) {
                maxIdleTimeout$value = SubscriptionWebSocket.$default$maxIdleTimeout();
            }
            int maxMessageSize$value = this.maxMessageSize$value;
            if (!this.maxMessageSize$set) {
                maxMessageSize$value = SubscriptionWebSocket.$default$maxMessageSize();
            }
            boolean sendPingOnSubscribe$value = this.sendPingOnSubscribe$value;
            if (!this.sendPingOnSubscribe$set) {
                sendPingOnSubscribe$value = SubscriptionWebSocket.$default$sendPingOnSubscribe();
            }
            DataFetcherExceptionHandler dataFetcherExceptionHandler$value = this.dataFetcherExceptionHandler$value;
            if (!this.dataFetcherExceptionHandler$set) {
                dataFetcherExceptionHandler$value = SubscriptionWebSocket.$default$dataFetcherExceptionHandler();
            }
            RouteResolver routeResolver$value = this.routeResolver$value;
            if (!this.routeResolver$set) {
                routeResolver$value = SubscriptionWebSocket.$default$routeResolver();
            }
            return new SubscriptionWebSocket(this.elide, this.executorService, connectionTimeout$value, maxSubscriptions$value, userFactory$value, maxIdleTimeout$value, maxMessageSize$value, sendPingOnSubscribe$value, dataFetcherExceptionHandler$value, routeResolver$value);
        }

        public String toString() {
            return "SubscriptionWebSocket.SubscriptionWebSocketBuilder(elide=" + this.elide + ", executorService=" + this.executorService + ", connectionTimeout$value=" + this.connectionTimeout$value + ", maxSubscriptions$value=" + this.maxSubscriptions$value + ", userFactory$value=" + this.userFactory$value + ", maxIdleTimeout$value=" + this.maxIdleTimeout$value + ", maxMessageSize$value=" + this.maxMessageSize$value + ", sendPingOnSubscribe$value=" + this.sendPingOnSubscribe$value + ", dataFetcherExceptionHandler$value=" + this.dataFetcherExceptionHandler$value + ", routeResolver$value=" + this.routeResolver$value + ")";
        }
    }
}

