/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.subscriptions;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.GraphQLConversionUtils;
import com.yahoo.elide.graphql.GraphQLNameUtils;
import com.yahoo.elide.graphql.GraphQLScalars;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.subscriptions.annotations.Subscription;
import com.yahoo.elide.graphql.subscriptions.annotations.SubscriptionField;
import com.yahoo.elide.graphql.subscriptions.hooks.TopicType;
import graphql.Scalars;
import graphql.language.EnumTypeDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionModelBuilder.class);
    private Map<Type<?>, GraphQLObjectType> queryObjectRegistry;
    private final String apiVersion;
    private GraphQLConversionUtils generator;
    private GraphQLNameUtils nameUtils;
    private EntityDictionary entityDictionary;
    private DataFetcher<?> dataFetcher;
    private GraphQLArgument filterArgument;
    private Set<Type<?>> excludedEntities;
    private Set<Type<?>> relationshipTypes;
    public static final String TOPIC_ARGUMENT = "topic";

    public SubscriptionModelBuilder(EntityDictionary entityDictionary, NonEntityDictionary nonEntityDictionary, DataFetcher<?> dataFetcher, String apiVersion) {
        this.generator = new GraphQLConversionUtils(entityDictionary, nonEntityDictionary);
        this.entityDictionary = entityDictionary;
        this.nameUtils = new GraphQLNameUtils(entityDictionary);
        this.dataFetcher = dataFetcher;
        this.apiVersion = apiVersion;
        this.excludedEntities = new HashSet();
        this.queryObjectRegistry = new HashMap();
        this.relationshipTypes = new HashSet();
        this.filterArgument = GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)Scalars.GraphQLString).build();
    }

    public void withExcludedEntities(Set<Type<?>> excludedEntities) {
        this.excludedEntities = excludedEntities;
    }

    public GraphQLSchema build() {
        Set allClasses = this.entityDictionary.getBoundClassesByVersion(this.apiVersion);
        if (allClasses.isEmpty()) {
            throw new IllegalArgumentException("None of the provided classes are exported by Elide");
        }
        Set subscriptionClasses = allClasses.stream().filter(cls -> this.entityDictionary.getAnnotation(cls, Subscription.class) != null).collect(Collectors.toSet());
        GraphQLObjectType.Builder root = GraphQLObjectType.newObject().name("Subscription");
        for (Object clazz : subscriptionClasses) {
            Subscription subscription = (Subscription)this.entityDictionary.getAnnotation((Type)clazz, Subscription.class);
            if (subscription == null) continue;
            GraphQLObjectType subscriptionType = this.buildQueryObject((Type<?>)clazz);
            String entityName = this.entityDictionary.getJsonAliasFor((Type)clazz);
            GraphQLFieldDefinition.Builder rootFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(entityName).description(EntityDictionary.getEntityDescription((Type)clazz)).argument(this.filterArgument).type((GraphQLOutputType)subscriptionType);
            if (subscription.operations() != null && subscription.operations().length > 0) {
                GraphQLEnumType.Builder topicTypeBuilder = GraphQLEnumType.newEnum().name(this.nameUtils.toTopicName((Type<?>)clazz));
                for (Subscription.Operation operation : subscription.operations()) {
                    TopicType topicType = TopicType.fromOperation(operation);
                    topicTypeBuilder.value(topicType.name(), (Object)topicType);
                }
                topicTypeBuilder.definition(EnumTypeDefinition.newEnumTypeDefinition().build());
                rootFieldDefinitionBuilder.argument(GraphQLArgument.newArgument().name(TOPIC_ARGUMENT).type((GraphQLInputType)topicTypeBuilder.build()).build());
            }
            root.field(rootFieldDefinitionBuilder.build());
        }
        GraphQLObjectType queryRoot = root.build();
        for (Type type : this.relationshipTypes) {
            this.buildQueryObject(type);
        }
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
        HashSet<GraphQLObjectType> hashSet = new HashSet<GraphQLObjectType>(this.queryObjectRegistry.values());
        hashSet.addAll(this.generator.getObjectTypes());
        hashSet.add(queryRoot);
        for (GraphQLObjectType objectType : hashSet) {
            String objectName = objectType.getName();
            for (GraphQLFieldDefinition fieldDefinition : objectType.getFieldDefinitions()) {
                codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)objectName, (String)fieldDefinition.getName()), this.dataFetcher);
            }
        }
        GraphQLSchema schema = GraphQLSchema.newSchema().subscription(queryRoot).query(queryRoot).codeRegistry(codeRegistry.build()).additionalTypes((Set)Sets.newHashSet(this.queryObjectRegistry.values())).build();
        return schema;
    }

    private GraphQLObjectType buildQueryObject(Type<?> entityClass) {
        if (this.queryObjectRegistry.containsKey(entityClass)) {
            return this.queryObjectRegistry.get(entityClass);
        }
        log.debug("Building subscription object for {}", (Object)entityClass.getName());
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(this.nameUtils.toOutputTypeName(entityClass)).description(EntityDictionary.getEntityDescription(entityClass));
        String id = this.entityDictionary.getIdFieldName(entityClass);
        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(id).type((GraphQLOutputType)GraphQLScalars.GRAPHQL_DEFERRED_ID));
        for (String attribute : this.entityDictionary.getAttributes(entityClass)) {
            Type attributeClass = this.entityDictionary.getType(entityClass, attribute);
            if (this.excludedEntities.contains(attributeClass) || this.entityDictionary.getAttributeOrRelationAnnotation(entityClass, SubscriptionField.class, attribute) == null) continue;
            log.debug("Building subscription attribute {} {} with arguments {} for entity {}", new Object[]{attribute, attributeClass.getName(), this.entityDictionary.getAttributeArguments(attributeClass, attribute).toString(), entityClass.getName()});
            GraphQLOutputType attributeType = this.generator.attributeToQueryObject(entityClass, attributeClass, attribute, this.dataFetcher);
            if (attributeType == null) continue;
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(attribute).arguments(this.generator.attributeArgumentToQueryObject(entityClass, attribute, this.dataFetcher)).type(attributeType));
        }
        for (String relationship : this.entityDictionary.getElideBoundRelationships(entityClass)) {
            log.debug("Resolving relationship {} for {}", (Object)relationship, (Object)entityClass.getName());
            Type relationshipClass = this.entityDictionary.getParameterizedType(entityClass, relationship);
            if (this.excludedEntities.contains(relationshipClass) || this.entityDictionary.getAttributeOrRelationAnnotation(entityClass, SubscriptionField.class, relationship) == null) continue;
            this.relationshipTypes.add(relationshipClass);
            RelationshipType type = this.entityDictionary.getRelationshipType(entityClass, relationship);
            String relationshipEntityName = this.nameUtils.toOutputTypeName(relationshipClass);
            if (type.isToOne()) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).type((GraphQLOutputType)new GraphQLTypeReference(relationshipEntityName)).build());
                continue;
            }
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(relationship).type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(relationshipEntityName))).build());
        }
        GraphQLObjectType queryObject = builder.build();
        this.queryObjectRegistry.put(entityClass, queryObject);
        return queryObject;
    }
}

