/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GraphQLErrorDeserializer
extends StdDeserializer<GraphQLError> {
    private static final long serialVersionUID = 1L;

    public GraphQLErrorDeserializer() {
        super(GraphQLError.class);
    }

    public GraphQLError deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        final JsonNode messageNode = root.get("message");
        final JsonNode pathNode = root.get("path");
        final JsonNode sourceLocations = root.get("locations");
        JsonNode extensions = root.get("extensions");
        final Map extensionsMap = extensions == null ? Collections.emptyMap() : (Map)parser.getCodec().treeToValue((TreeNode)extensions, Map.class);
        return new GraphQLError(){
            private static final long serialVersionUID = 1L;

            public String toString() {
                return String.format("{ \"message\": \"%s\", \"locations\": %s, \"path\": %s}", this.getMessage(), this.getLocations(), this.getPath());
            }

            public String getMessage() {
                return messageNode == null ? null : messageNode.textValue();
            }

            public List<SourceLocation> getLocations() {
                if (sourceLocations != null) {
                    ArrayList<SourceLocation> result = new ArrayList<SourceLocation>();
                    sourceLocations.forEach(sourceLocation -> result.add(new SourceLocation(sourceLocation.get("line").asInt(), sourceLocation.get("column").asInt())));
                    return result;
                }
                return null;
            }

            public Map<String, Object> getExtensions() {
                return extensionsMap;
            }

            public ErrorClassification getErrorType() {
                Object classification = extensionsMap.get("classification");
                if (classification == null) {
                    classification = "DataFetchingException";
                }
                return ErrorClassification.errorClassification((String)classification.toString());
            }

            public List<Object> getPath() {
                if (pathNode != null) {
                    ArrayList<Object> paths = new ArrayList<Object>();
                    pathNode.forEach(path -> paths.add(path.asText()));
                    return paths;
                }
                return null;
            }
        };
    }
}

