/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class ExecutionResultDeserializer
extends StdDeserializer<ExecutionResult> {
    private static final long serialVersionUID = 1L;

    public ExecutionResultDeserializer() {
        super(ExecutionResult.class);
    }

    public ExecutionResult deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode dataNode = root.get("data");
        JsonNode errorsNode = root.get("errors");
        ArrayList<GraphQLError> errors = null;
        if (errorsNode != null) {
            errors = new ArrayList<GraphQLError>();
            for (JsonNode errorNode : errorsNode) {
                errors.add((GraphQLError)parser.getCodec().treeToValue((TreeNode)errorNode, GraphQLError.class));
            }
        }
        Map data = (Map)parser.getCodec().treeToValue((TreeNode)dataNode, Map.class);
        return ExecutionResultImpl.newExecutionResult().errors(errors).data((Object)data).build();
    }
}

