/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.graphql.parser.GraphQLQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface QueryParser {
    public static final String QUERY = "query";
    public static final String OPERATION_NAME = "operationName";
    public static final String VARIABLES = "variables";

    default public List<GraphQLQuery> parseDocument(String message, ObjectMapper mapper) throws IOException {
        ArrayList<GraphQLQuery> results = new ArrayList<GraphQLQuery>();
        JsonNode topLevel = mapper.readTree(message);
        if (topLevel.isArray()) {
            for (JsonNode document : topLevel) {
                results.add(this.parseQuery(document, mapper));
            }
        } else {
            results.add(this.parseQuery(topLevel, mapper));
        }
        return results;
    }

    default public GraphQLQuery parseQuery(JsonNode topLevel, ObjectMapper mapper) throws IOException {
        String query = topLevel.has(QUERY) ? topLevel.get(QUERY).asText() : null;
        String operationName = "";
        Map<String, Object> variables = new HashMap<String, Object>();
        if (topLevel.has(VARIABLES) && !topLevel.get(VARIABLES).isNull()) {
            variables = (Map)mapper.convertValue((Object)topLevel.get(VARIABLES), Map.class);
        }
        if (topLevel.has(OPERATION_NAME) && !topLevel.get(OPERATION_NAME).isNull()) {
            operationName = topLevel.get(OPERATION_NAME).asText();
        }
        return new GraphQLQuery(query, operationName, variables);
    }
}

