/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.parser;

import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FragmentResolver {
    private final Map<String, FragmentDefinition> fragmentMap = new HashMap<String, FragmentDefinition>();

    public boolean contains(String fragmentName) {
        return this.fragmentMap.containsKey(fragmentName);
    }

    public FragmentDefinition get(String fragmentName) {
        return this.fragmentMap.get(fragmentName);
    }

    public void addFragments(Document document) {
        this.addFragments(document.getDefinitions().stream().filter(definition -> definition instanceof FragmentDefinition).map(definition -> (FragmentDefinition)definition).collect(Collectors.toList()));
    }

    private void addFragments(List<FragmentDefinition> fragments) {
        Map newFragments = fragments.stream().collect(Collectors.toMap(FragmentDefinition::getName, Function.identity()));
        HashSet fragmentNames = new HashSet();
        fragments.forEach(fragmentDefinition -> FragmentResolver.validateFragment(newFragments, fragmentDefinition, fragmentNames));
        this.fragmentMap.putAll(newFragments);
    }

    private static void validateFragment(Map<String, FragmentDefinition> fragmentMap, FragmentDefinition fragmentDefinition, Set<String> fragmentNames) {
        String fragmentName = fragmentDefinition.getName();
        if (fragmentNames.contains(fragmentName)) {
            throw new InvalidEntityBodyException("There is a fragment definition loop in: {" + String.join((CharSequence)",", fragmentNames) + "} with " + fragmentName + " duplicated.");
        }
        fragmentNames.add(fragmentName);
        FragmentResolver.getNestedFragments(fragmentDefinition.getSelectionSet()).stream().map(FragmentSpread::getName).distinct().forEach(name -> {
            if (!fragmentMap.containsKey(name)) {
                throw new InvalidEntityBodyException(String.format("Unknown fragment {%s}.", name));
            }
            FragmentResolver.validateFragment(fragmentMap, (FragmentDefinition)fragmentMap.get(name), fragmentNames);
        });
        fragmentNames.remove(fragmentName);
    }

    private static List<FragmentSpread> getNestedFragments(SelectionSet selectionSet) {
        return selectionSet.getSelections().stream().map(FragmentResolver::getNestedFragments).reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    private static List<FragmentSpread> getNestedFragments(Selection selection) {
        if (selection instanceof Field) {
            return ((Field)selection).getSelectionSet() == null || ((Field)selection).getSelectionSet().getSelections().isEmpty() ? new ArrayList<FragmentSpread>() : FragmentResolver.getNestedFragments(((Field)selection).getSelectionSet());
        }
        if (selection instanceof FragmentSpread) {
            return Collections.singletonList((FragmentSpread)selection);
        }
        throw new BadRequestException("Unsupported graphQL selection type: " + selection.getClass());
    }
}

