/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.elide.graphql.models.GraphQLError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class GraphQLErrors {
    private final List<graphql.GraphQLError> errors;

    @JsonCreator
    public GraphQLErrors(@JsonProperty(value="errors") List<graphql.GraphQLError> errors) {
        this.errors = Objects.requireNonNull(errors, "errors must not be null");
    }

    public static GraphQLErrorsBuilder builder() {
        return new GraphQLErrorsBuilder();
    }

    public List<graphql.GraphQLError> getErrors() {
        return this.errors;
    }

    public static class GraphQLErrorsBuilder {
        private List<graphql.GraphQLError> errors = new ArrayList<graphql.GraphQLError>();

        public GraphQLErrorsBuilder error(graphql.GraphQLError ... error) {
            this.errors.addAll(Arrays.asList(error));
            return this;
        }

        public GraphQLErrorsBuilder error(Consumer<GraphQLError.GraphQLErrorBuilder> error) {
            GraphQLError.GraphQLErrorBuilder builder = GraphQLError.builder();
            error.accept(builder);
            return this.error(builder.build());
        }

        public GraphQLErrorsBuilder errors(List<graphql.GraphQLError> errors) {
            this.errors = errors;
            return this;
        }

        public GraphQLErrorsBuilder errors(Consumer<List<graphql.GraphQLError>> errors) {
            errors.accept(this.errors);
            return this;
        }

        public GraphQLErrors build() {
            if (this.errors.isEmpty()) {
                throw new IllegalArgumentException("At least one error is required");
            }
            return new GraphQLErrors(this.errors);
        }
    }
}

