/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.models;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.graphql.models.SourceLocationBuilder;
import com.yahoo.elide.graphql.serialization.GraphQLErrorSerializer;
import graphql.Assert;
import graphql.ErrorClassification;
import graphql.GraphqlErrorBuilder;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GraphQLError {
    private GraphQLError() {
    }

    public static GraphQLErrorBuilder builder() {
        return new GraphQLErrorBuilder();
    }

    public static class GraphQLErrorBuilder
    extends GraphqlErrorBuilder<GraphQLErrorBuilder> {
        private Map<String, Object> extensions = new LinkedHashMap<String, Object>();
        private List<SourceLocation> locations = null;

        public GraphQLErrorBuilder path(Object ... path) {
            return (GraphQLErrorBuilder)this.path(Arrays.asList(path));
        }

        public GraphQLErrorBuilder location(Consumer<SourceLocationBuilder> location) {
            SourceLocationBuilder builder = new SourceLocationBuilder();
            location.accept(builder);
            if (this.getLocations() == null) {
                this.locations = new ArrayList<SourceLocation>();
            }
            return this.location(builder.build());
        }

        public GraphQLErrorBuilder locations(Consumer<List<SourceLocation>> locations) {
            if (this.getLocations() == null) {
                this.locations = new ArrayList<SourceLocation>();
            }
            locations.accept(this.getLocations());
            return this;
        }

        public GraphQLErrorBuilder extension(String key, Object value) {
            this.extensions.put(key, value);
            return (GraphQLErrorBuilder)super.extensions(this.extensions);
        }

        public GraphQLErrorBuilder extensions(Consumer<Map<String, Object>> extensions) {
            extensions.accept(this.extensions);
            return (GraphQLErrorBuilder)super.extensions(this.extensions);
        }

        public GraphQLErrorBuilder extensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return (GraphQLErrorBuilder)super.extensions(this.extensions);
        }

        public GraphQLErrorBuilder locations(List<SourceLocation> locations) {
            if (this.getLocations() == null) {
                this.locations = new ArrayList<SourceLocation>();
            }
            this.locations.addAll(locations);
            return this;
        }

        public GraphQLErrorBuilder location(SourceLocation location) {
            if (this.getLocations() == null) {
                this.locations = new ArrayList<SourceLocation>();
            }
            this.locations.add(location);
            return this;
        }

        public List<SourceLocation> getLocations() {
            return this.locations;
        }

        public graphql.GraphQLError build() {
            Assert.assertNotNull((Object)this.getMessage(), () -> "You must provide error message");
            return new BasicGraphQLError(this.getMessage(), this.locations, this.getErrorType(), this.getPath(), this.extensions.isEmpty() ? null : this.extensions);
        }

        @JsonSerialize(using=GraphQLErrorSerializer.class)
        private static class BasicGraphQLError
        implements graphql.GraphQLError {
            private static final long serialVersionUID = 1L;
            private final String message;
            private final List<SourceLocation> locations;
            private final ErrorClassification errorType;
            private final List<Object> path;
            private final Map<String, Object> extensions;

            public BasicGraphQLError(String message, List<SourceLocation> locations, ErrorClassification errorType, List<Object> path, Map<String, Object> extensions) {
                this.message = message;
                this.locations = locations;
                this.errorType = errorType;
                this.path = path;
                this.extensions = extensions;
            }

            public String getMessage() {
                return this.message;
            }

            public List<SourceLocation> getLocations() {
                return this.locations;
            }

            public ErrorClassification getErrorType() {
                return this.errorType;
            }

            public List<Object> getPath() {
                return this.path;
            }

            public Map<String, Object> getExtensions() {
                return this.extensions;
            }

            public String toString() {
                return this.message;
            }
        }
    }
}

