/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.KeyWord;
import com.yahoo.elide.graphql.containers.ConnectionContainer;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PageInfoContainer
implements GraphQLContainer {
    private final ConnectionContainer connectionContainer;

    public PageInfoContainer(ConnectionContainer connectionContainer) {
        this.connectionContainer = connectionContainer;
    }

    public Object processFetch(Environment context) {
        String fieldName = context.field.getName();
        ConnectionContainer connectionContainer = this.getConnectionContainer();
        Optional<Pagination> pagination = connectionContainer.getPagination();
        List ids = connectionContainer.getPersistentResources().stream().map(PersistentResource::getId).sorted().collect(Collectors.toList());
        return pagination.map(pageValue -> {
            switch (KeyWord.byName(fieldName)) {
                case PAGE_INFO_HAS_NEXT_PAGE: {
                    int numResults = ids.size();
                    int nextOffset = numResults + pageValue.getOffset();
                    return Boolean.valueOf((long)nextOffset < pageValue.getPageTotals());
                }
                case PAGE_INFO_START_CURSOR: {
                    return Integer.valueOf(pageValue.getOffset());
                }
                case PAGE_INFO_END_CURSOR: {
                    return Integer.valueOf(pageValue.getOffset() + ids.size());
                }
                case PAGE_INFO_TOTAL_RECORDS: {
                    return pageValue.getPageTotals();
                }
            }
            throw new BadRequestException("Invalid request. Looking for field: " + fieldName + " in an pageInfo object.");
        }).orElseThrow(() -> new BadRequestException("Could not generate pagination information for type: " + connectionContainer.getTypeName()));
    }

    public ConnectionContainer getConnectionContainer() {
        return this.connectionContainer;
    }
}

