/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.DeferredId;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import com.yahoo.elide.graphql.containers.MapEntryContainer;
import com.yahoo.elide.graphql.containers.NonEntityContainer;
import com.yahoo.elide.graphql.containers.PersistentResourceContainer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NodeContainer
implements PersistentResourceContainer,
GraphQLContainer {
    protected final PersistentResource persistentResource;

    public Object processFetch(Environment context) {
        EntityDictionary entityDictionary = context.requestScope.getDictionary();
        NonEntityDictionary nonEntityDictionary = context.nonEntityDictionary;
        Type parentClass = context.parentResource.getResourceType();
        String fieldName = context.field.getName();
        String idFieldName = entityDictionary.getIdFieldName(parentClass);
        if (entityDictionary.isAttribute(parentClass, fieldName)) {
            Type innerType;
            Attribute requested = context.requestScope.getProjectionInfo().getAttributeMap().getOrDefault(context.field.getSourceLocation(), null);
            Object attribute = context.parentResource.getAttribute(requested);
            if (attribute != null && nonEntityDictionary.hasBinding(EntityDictionary.getType((Object)attribute))) {
                return new NonEntityContainer(attribute);
            }
            if (attribute instanceof Map) {
                return ((Map)attribute).entrySet().stream().map(MapEntryContainer::new).collect(Collectors.toList());
            }
            if (attribute instanceof Collection && nonEntityDictionary.hasBinding(innerType = entityDictionary.getParameterizedType(parentClass, fieldName))) {
                return ((Collection)attribute).stream().map(NonEntityContainer::new).collect(Collectors.toList());
            }
            return attribute;
        }
        if (entityDictionary.isRelation(parentClass, fieldName)) {
            Relationship relationship = context.requestScope.getProjectionInfo().getRelationshipMap().getOrDefault(context.field.getSourceLocation(), null);
            if (relationship == null) {
                throw new BadRequestException("Relationship doesn't have projection " + context.parentResource.getTypeName() + "." + fieldName);
            }
            return this.fetchRelationship(context, relationship);
        }
        if (Objects.equals(idFieldName, fieldName)) {
            return new DeferredId(context.parentResource);
        }
        throw new BadRequestException("Unrecognized object: " + fieldName + " for: " + parentClass.getName() + " in node");
    }

    protected Object fetchRelationship(Environment context, Relationship relationship) {
        return PersistentResourceFetcher.fetchRelationship(context.parentResource, relationship, context.ids);
    }

    public NodeContainer(PersistentResource persistentResource) {
        this.persistentResource = persistentResource;
    }

    @Override
    public PersistentResource getPersistentResource() {
        return this.persistentResource;
    }
}

