/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql.containers;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.KeyWord;
import com.yahoo.elide.graphql.containers.EdgesContainer;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import com.yahoo.elide.graphql.containers.PageInfoContainer;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConnectionContainer
implements GraphQLContainer {
    private final Set<PersistentResource> persistentResources;
    private final Optional<Pagination> pagination;
    private final String typeName;

    public Object processFetch(Environment context) {
        String fieldName = context.field.getName();
        switch (KeyWord.byName(fieldName)) {
            case EDGES: {
                return this.getPersistentResources().stream().map(EdgesContainer::new).collect(Collectors.toList());
            }
            case PAGE_INFO: {
                return new PageInfoContainer(this);
            }
        }
        throw new BadRequestException("Invalid request. Looking for field: " + fieldName + " in a connection object.");
    }

    public ConnectionContainer(Set<PersistentResource> persistentResources, Optional<Pagination> pagination, String typeName) {
        this.persistentResources = persistentResources;
        this.pagination = pagination;
        this.typeName = typeName;
    }

    public Set<PersistentResource> getPersistentResources() {
        return this.persistentResources;
    }

    public Optional<Pagination> getPagination() {
        return this.pagination;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

