/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.GraphQLErrorContext;
import com.yahoo.elide.graphql.GraphQLExceptionHandler;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.GraphQLSettings;
import com.yahoo.elide.graphql.ModelBuilder;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.graphql.RelationshipOp;
import com.yahoo.elide.graphql.parser.GraphQLEntityProjectionMaker;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import com.yahoo.elide.graphql.parser.GraphQLQuery;
import com.yahoo.elide.graphql.parser.QueryParser;
import com.yahoo.elide.graphql.serialization.GraphQLModule;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunner {
    private static final Logger log = LoggerFactory.getLogger(QueryRunner.class);
    private final Elide elide;
    private GraphQL api;
    private String apiVersion;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String MUTATION = "mutation";

    public QueryRunner(Elide elide, String apiVersion) {
        this(elide, apiVersion, (DataFetcherExceptionHandler)new SimpleDataFetcherExceptionHandler());
    }

    public QueryRunner(Elide elide, String apiVersion, DataFetcherExceptionHandler exceptionHandler) {
        this.elide = elide;
        this.apiVersion = apiVersion;
        EntityDictionary dictionary = elide.getElideSettings().getEntityDictionary();
        NonEntityDictionary nonEntityDictionary = new NonEntityDictionary(dictionary.getScanner(), dictionary.getSerdeLookup());
        PersistentResourceFetcher fetcher = new PersistentResourceFetcher(nonEntityDictionary);
        ModelBuilder builder = new ModelBuilder(elide.getElideSettings().getEntityDictionary(), nonEntityDictionary, elide.getElideSettings(), fetcher, apiVersion);
        this.api = GraphQL.newGraphQL((GraphQLSchema)builder.build()).defaultDataFetcherExceptionHandler(exceptionHandler).queryExecutionStrategy((ExecutionStrategy)new AsyncSerialExecutionStrategy(exceptionHandler)).build();
        elide.getElideSettings().getObjectMapper().registerModule((Module)new GraphQLModule());
    }

    public ElideResponse<String> run(String baseUrlEndPoint, String graphQLDocument, User user) {
        return this.run(baseUrlEndPoint, graphQLDocument, user, UUID.randomUUID());
    }

    public static boolean isMutation(String query) {
        if (query == null) {
            return false;
        }
        String[] lines = query.split("\n");
        StringBuilder withoutComments = new StringBuilder();
        for (String line : lines) {
            if (line.matches("^(\\s*)#.*")) continue;
            withoutComments.append(line);
            withoutComments.append("\n");
        }
        query = withoutComments.toString().trim();
        return query.startsWith(MUTATION);
    }

    public static JsonNode getTopLevelNode(ObjectMapper mapper, String graphQLDocument) throws IOException {
        return mapper.readTree(graphQLDocument);
    }

    public ElideResponse<String> run(String baseUrlEndPoint, String graphQLDocument, User user, UUID requestId) {
        return this.run(baseUrlEndPoint, graphQLDocument, user, requestId, null);
    }

    public ElideResponse<String> run(String baseUrlEndPoint, String graphQLDocument, User user, UUID requestId, Map<String, List<String>> requestHeaders) {
        List<GraphQLQuery> queries;
        ObjectMapper mapper = this.elide.getObjectMapper();
        try {
            queries = new QueryParser(){}.parseDocument(graphQLDocument, mapper);
        }
        catch (IOException e) {
            log.debug("Invalid json body provided to GraphQL", (Throwable)e);
            return QueryRunner.handleRuntimeException(this.elide, (RuntimeException)new InvalidEntityBodyException(graphQLDocument, (Throwable)e));
        }
        ArrayList responses = new ArrayList();
        for (GraphQLQuery query : queries) {
            responses.add(this.executeGraphQLRequest(baseUrlEndPoint, mapper, user, graphQLDocument, query, requestId, requestHeaders));
        }
        if (responses.size() == 1) {
            return QueryRunner.map((ElideResponse)responses.get(0), this.elide.getObjectMapper());
        }
        ArrayNode result = responses.stream().map(response -> {
            try {
                String body = mapper.writeValueAsString(response.getBody());
                return mapper.readTree(body);
            }
            catch (IOException e) {
                log.debug("Caught an IO exception while trying to read response body");
                return JsonNodeFactory.instance.objectNode();
            }
        }).reduce(JsonNodeFactory.instance.arrayNode(), (arrayNode, node) -> arrayNode.add(node), (left, right) -> left.addAll(right));
        return QueryRunner.map(ElideResponse.ok((Object)result), this.elide.getObjectMapper());
    }

    private static ElideResponse<String> map(ElideResponse<?> response, ObjectMapper objectMapper) {
        Object object = response.getBody();
        if (object instanceof String) {
            String string = (String)object;
            return ElideResponse.status((int)response.getStatus()).body((Object)string);
        }
        try {
            Object body = response.getBody();
            return ElideResponse.status((int)response.getStatus()).body(body != null ? objectMapper.writeValueAsString(body) : null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String extractQuery(JsonNode jsonDocument) {
        return jsonDocument.has(QUERY) ? jsonDocument.get(QUERY).asText() : null;
    }

    public static Map<String, Object> extractVariables(ObjectMapper mapper, JsonNode jsonDocument) {
        Map<String, Object> variables = new HashMap<String, Object>();
        if (jsonDocument.has(VARIABLES) && !jsonDocument.get(VARIABLES).isNull()) {
            variables = (Map)mapper.convertValue((Object)jsonDocument.get(VARIABLES), Map.class);
        }
        return variables;
    }

    public static String extractOperation(JsonNode jsonDocument) {
        if (jsonDocument.has(OPERATION_NAME) && !jsonDocument.get(OPERATION_NAME).isNull()) {
            return jsonDocument.get(OPERATION_NAME).asText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElideResponse<?> executeGraphQLRequest(String baseUrlEndPoint, ObjectMapper mapper, User principal, String graphQLDocument, GraphQLQuery query, UUID requestId, Map<String, List<String>> requestHeaders) {
        String queryText = query.getQuery();
        boolean isMutation = QueryRunner.isMutation(queryText);
        try {
            ElideResponse elideResponse;
            block21: {
                DataStoreTransaction tx;
                block19: {
                    ElideResponse elideResponse2;
                    block20: {
                        tx = isMutation ? this.elide.getDataStore().beginTransaction() : this.elide.getDataStore().beginReadTransaction();
                        try {
                            this.elide.getTransactionRegistry().addRunningTransaction(requestId, tx);
                            if (query.getQuery() != null && !query.getQuery().isEmpty()) break block19;
                            elideResponse2 = ElideResponse.badRequest((Object)"A `query` key is required.");
                            if (tx == null) break block20;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (tx != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                ElideResponse<String> elideResponse3 = QueryRunner.handleNonRuntimeException(this.elide, e, graphQLDocument);
                                return elideResponse3;
                            }
                            catch (RuntimeException e) {
                                ElideResponse<String> elideResponse4 = QueryRunner.handleRuntimeException(this.elide, e);
                                return elideResponse4;
                            }
                        }
                        tx.close();
                    }
                    return elideResponse2;
                }
                Map<String, Object> variables = query.getVariables();
                GraphQLProjectionInfo projectionInfo = new GraphQLEntityProjectionMaker(this.elide.getElideSettings(), variables, this.apiVersion).make(queryText);
                Route route = Route.builder().baseUrl(baseUrlEndPoint).apiVersion(this.apiVersion).headers(requestHeaders).build();
                GraphQLRequestScope requestScope = GraphQLRequestScope.builder().route(route).dataStoreTransaction(tx).user(principal).requestId(requestId).elideSettings(this.elide.getElideSettings()).projectionInfo(projectionInfo).build();
                log.info("Processing GraphQL query:\n{}", (Object)queryText);
                ExecutionInput.Builder executionInput = new ExecutionInput.Builder().localContext((Object)requestScope).query(queryText);
                if (query.getOperationName() != null) {
                    executionInput.operationName(query.getOperationName());
                }
                executionInput.variables(variables);
                ExecutionResult result = this.api.execute(executionInput);
                tx.preCommit((RequestScope)requestScope);
                requestScope.getPermissionExecutor().executeCommitChecks();
                if (isMutation) {
                    if (!result.getErrors().isEmpty()) {
                        HashMap<String, List<GraphQLError>> abortedResponseObject = new HashMap<String, List<GraphQLError>>();
                        abortedResponseObject.put("errors", this.mapErrors(result.getErrors()));
                        abortedResponseObject.put("data", null);
                        throw new GraphQLException(mapper.writeValueAsString(abortedResponseObject));
                    }
                    requestScope.saveOrCreateObjects();
                }
                tx.flush((RequestScope)requestScope);
                requestScope.runQueuedPreCommitTriggers();
                this.elide.getAuditLogger().commit();
                tx.commit((RequestScope)requestScope);
                requestScope.runQueuedPostCommitTriggers();
                if (log.isTraceEnabled()) {
                    requestScope.getPermissionExecutor().logCheckStats();
                }
                elideResponse = ElideResponse.ok((Object)result);
                if (tx == null) break block21;
                tx.close();
            }
            return elideResponse;
        }
        finally {
            this.elide.getTransactionRegistry().removeRunningTransaction(requestId);
            this.elide.getAuditLogger().clear();
        }
    }

    private List<GraphQLError> mapErrors(List<GraphQLError> errors) {
        ArrayList<GraphQLError> result = new ArrayList<GraphQLError>(errors.size());
        for (GraphQLError error : errors) {
            ValidationError validationError;
            if (error instanceof ValidationError && ValidationErrorType.WrongType.equals((Object)(validationError = (ValidationError)error).getValidationErrorType()) && validationError.getDescription().contains("ElideRelationshipOp")) {
                String queryPath = String.join((CharSequence)" ", validationError.getQueryPath());
                RelationshipOp relationshipOp = Arrays.stream(RelationshipOp.values()).filter(op -> validationError.getDescription().contains(op.name())).findFirst().orElse(null);
                if (relationshipOp != null) {
                    result.add((GraphQLError)ValidationError.newValidationError().description("Invalid operation: " + relationshipOp.name() + " is not permitted on " + queryPath + ".").extensions(validationError.getExtensions()).validationErrorType(validationError.getValidationErrorType()).sourceLocations(validationError.getLocations()).queryPath(validationError.getQueryPath()).build());
                    continue;
                }
            }
            result.add(error);
        }
        return result;
    }

    public static ElideResponse<String> handleNonRuntimeException(Elide elide, Exception exception, String graphQLDocument) {
        boolean verbose = elide.getElideSettings().isVerboseErrors();
        ObjectMapper mapper = elide.getObjectMapper();
        GraphQLErrorContext errorContext = GraphQLErrorContext.builder().verbose(verbose).objectMapper(mapper).graphQLDocument(graphQLDocument).build();
        GraphQLExceptionHandler exceptionHandler = ((GraphQLSettings)elide.getSettings(GraphQLSettings.class)).getGraphqlExceptionHandler();
        return QueryRunner.map(exceptionHandler.handleException(exception, errorContext), mapper);
    }

    public static ElideResponse<String> handleRuntimeException(Elide elide, RuntimeException exception) {
        boolean verbose = elide.getElideSettings().isVerboseErrors();
        ObjectMapper mapper = elide.getObjectMapper();
        GraphQLErrorContext errorContext = GraphQLErrorContext.builder().verbose(verbose).objectMapper(mapper).build();
        GraphQLExceptionHandler exceptionHandler = ((GraphQLSettings)elide.getSettings(GraphQLSettings.class)).getGraphqlExceptionHandler();
        return QueryRunner.map(exceptionHandler.handleException(exception, errorContext), mapper);
    }

    public Elide getElide() {
        return this.elide;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

