/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.graphql.Entity;
import com.yahoo.elide.graphql.Environment;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.QueryLogger;
import com.yahoo.elide.graphql.RelationshipOp;
import com.yahoo.elide.graphql.containers.ConnectionContainer;
import com.yahoo.elide.graphql.containers.MapEntryContainer;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.reactivex.Observable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentResourceFetcher
implements DataFetcher<Object>,
QueryLogger {
    private static final Logger log = LoggerFactory.getLogger(PersistentResourceFetcher.class);
    private final NonEntityDictionary nonEntityDictionary;

    public PersistentResourceFetcher(NonEntityDictionary nonEntityDictionary) {
        this.nonEntityDictionary = nonEntityDictionary;
    }

    public Object get(DataFetchingEnvironment environment) {
        ConnectionContainer container;
        Map args = environment.getArguments();
        RelationshipOp operation = args.getOrDefault("op", RelationshipOp.FETCH);
        Environment context = new Environment(environment, this.nonEntityDictionary);
        if (log.isDebugEnabled()) {
            this.logContext(log, operation, context);
        }
        if (operation != RelationshipOp.FETCH) {
            if (environment.getOperationDefinition().getOperation() != OperationDefinition.Operation.MUTATION) {
                throw new BadRequestException("Data model writes are only allowed in mutations");
            }
            this.filterSortPaginateSanityCheck(context);
        }
        switch (operation) {
            case FETCH: {
                return this.fetchObjects(context);
            }
            case UPSERT: {
                container = this.upsertObjects(context);
                break;
            }
            case UPDATE: {
                container = this.updateObjects(context);
                break;
            }
            case DELETE: {
                container = this.deleteObjects(context);
                break;
            }
            case REMOVE: {
                container = this.removeObjects(context);
                break;
            }
            case REPLACE: {
                container = this.replaceObjects(context);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation: " + operation);
            }
        }
        if (operation != RelationshipOp.FETCH) {
            context.requestScope.runQueuedPreSecurityTriggers();
            context.requestScope.runQueuedPreFlushTriggers();
        }
        return container;
    }

    private void filterSortPaginateSanityCheck(Environment environment) {
        if (environment.filters.isPresent() || environment.sort.isPresent() || environment.offset.isPresent() || environment.first.isPresent()) {
            throw new BadRequestException("Pagination/Filtering/Sorting is only supported with FETCH operation");
        }
    }

    private Object fetchObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("FETCH must not include data");
        }
        return context.container.processFetch(context);
    }

    public static ConnectionContainer fetchObject(RequestScope requestScope, EntityProjection projection, Optional<List<String>> ids) {
        EntityDictionary dictionary = requestScope.getDictionary();
        String typeName = dictionary.getJsonAliasFor(projection.getType());
        Observable records = ids.map(idList -> {
            if (idList.isEmpty()) {
                throw new BadRequestException("Empty list passed to ids");
            }
            return PersistentResource.loadRecords((EntityProjection)projection, (List)idList, (RequestScope)requestScope);
        }).orElseGet(() -> PersistentResource.loadRecords((EntityProjection)projection, new ArrayList(), (RequestScope)requestScope));
        return new ConnectionContainer((Set)records.toList(LinkedHashSet::new).blockingGet(), Optional.ofNullable(projection.getPagination()), typeName);
    }

    public static ConnectionContainer fetchRelationship(PersistentResource<?> parentResource, @NotNull Relationship relationship, Optional<List<String>> ids) {
        EntityDictionary dictionary = parentResource.getRequestScope().getDictionary();
        Type relationshipClass = dictionary.getParameterizedType(parentResource.getObject(), relationship.getName());
        String relationshipType = dictionary.getJsonAliasFor(relationshipClass);
        Set relationResources = ids.isPresent() ? (Set)parentResource.getRelation(ids.get(), relationship).toList(LinkedHashSet::new).blockingGet() : (Set)parentResource.getRelationCheckedFiltered(relationship).toList(LinkedHashSet::new).blockingGet();
        return new ConnectionContainer(relationResources, Optional.ofNullable(relationship.getProjection().getPagination()), relationshipType);
    }

    private ConnectionContainer upsertObjects(Environment context) {
        return this.upsertOrUpdateObjects(context, this::upsertObject, RelationshipOp.UPSERT);
    }

    private ConnectionContainer updateObjects(Environment context) {
        return this.upsertOrUpdateObjects(context, this::updateObject, RelationshipOp.UPDATE);
    }

    private ConnectionContainer upsertOrUpdateObjects(Environment context, Executor<?> updateFunc, RelationshipOp operation) {
        Optional<Entity> parentEntity;
        Type entityClass;
        if (context.ids.isPresent()) {
            throw new BadRequestException(operation + " must not include ids");
        }
        if (!context.data.isPresent()) {
            throw new BadRequestException(operation + " must include data argument");
        }
        EntityDictionary dictionary = context.requestScope.getDictionary();
        if (context.isRoot()) {
            entityClass = dictionary.getEntityClass(context.field.getName(), context.requestScope.getRoute().getApiVersion());
        } else {
            assert (context.parentResource != null);
            entityClass = dictionary.getParameterizedType(context.parentResource.getResourceType(), context.field.getName());
        }
        if (!context.isRoot()) {
            assert (context.parentResource != null);
            parentEntity = Optional.of(new Entity(Optional.empty(), null, context.parentResource.getResourceType(), context.requestScope));
        } else {
            parentEntity = Optional.empty();
        }
        LinkedHashSet<Entity> entitySet = new LinkedHashSet<Entity>();
        for (Map<String, Object> input : context.data.orElseThrow(IllegalStateException::new)) {
            entitySet.add(new Entity(parentEntity, input, entityClass, context.requestScope));
        }
        for (Entity entity : entitySet) {
            this.graphWalker(entity, updateFunc, context);
        }
        for (Entity entity : entitySet) {
            this.graphWalker(entity, this::updateRelationship, context);
            PersistentResource childResource = entity.toPersistentResource();
            if (context.isRoot()) continue;
            assert (context.parentResource != null);
            context.parentResource.addRelation(context.field.getName(), childResource);
        }
        String entityName = dictionary.getJsonAliasFor(entityClass);
        Set resources = entitySet.stream().map(Entity::toPersistentResource).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ConnectionContainer(resources, Optional.empty(), entityName);
    }

    private void graphWalker(Entity entity, Executor<?> function, Environment context) {
        ArrayDeque<Entity> toVisit = new ArrayDeque<Entity>();
        LinkedHashSet<Entity> visited = new LinkedHashSet<Entity>();
        toVisit.add(entity);
        while (!toVisit.isEmpty()) {
            Entity currentEntity = (Entity)toVisit.remove();
            if (visited.contains(currentEntity)) continue;
            visited.add(currentEntity);
            function.execute(currentEntity, context);
            Set<Entity.Relationship> relationshipEntities = currentEntity.getRelationships();
            for (Entity.Relationship relationship : relationshipEntities) {
                toVisit.addAll(relationship.getValue());
            }
        }
    }

    private PersistentResource<?> updateRelationship(Entity entity, Environment context) {
        Set<Entity.Relationship> relationshipEntities = entity.getRelationships();
        PersistentResource resource = entity.toPersistentResource();
        for (Entity.Relationship relationship : relationshipEntities) {
            LinkedHashSet<PersistentResource> toUpdate = new LinkedHashSet<PersistentResource>();
            for (Entity relation : relationship.getValue()) {
                toUpdate.add(relation.toPersistentResource());
            }
            resource.updateRelation(relationship.getName(), toUpdate);
        }
        return resource;
    }

    private PersistentResource upsertObject(Entity entity, Environment context) {
        PersistentResource upsertedResource;
        Set<Entity.Attribute> attributes = entity.getAttributes();
        Optional<String> id = entity.getId();
        RequestScope requestScope = entity.getRequestScope();
        EntityDictionary dictionary = requestScope.getDictionary();
        PersistentResource parentResource = entity.getParentResource().map(Entity::toPersistentResource).orElse(null);
        if (!id.isPresent()) {
            if (dictionary.isIdGenerated(entity.getEntityClass())) {
                entity.setId();
                id = entity.getId();
            }
            upsertedResource = PersistentResource.createObject((PersistentResource)parentResource, (String)context.field.getName(), entity.getEntityClass(), (RequestScope)requestScope, id);
        } else {
            try {
                Set<PersistentResource> loadedResource = PersistentResourceFetcher.fetchObject(requestScope, entity.getProjection(), Optional.of(Collections.singletonList(id.get()))).getPersistentResources();
                upsertedResource = loadedResource.iterator().next();
            }
            catch (InvalidObjectIdentifierException | InvalidValueException e) {
                upsertedResource = PersistentResource.createObject((PersistentResource)parentResource, (String)context.field.getName(), entity.getEntityClass(), (RequestScope)requestScope, id);
            }
        }
        return this.updateAttributes(upsertedResource, entity, attributes);
    }

    private PersistentResource updateObject(Entity entity, Environment context) {
        Set<Entity.Attribute> attributes = entity.getAttributes();
        Optional<String> id = entity.getId();
        RequestScope requestScope = entity.getRequestScope();
        if (!id.isPresent()) {
            throw new BadRequestException("UPDATE data objects must include ids");
        }
        Set<PersistentResource> loadedResource = PersistentResourceFetcher.fetchObject(requestScope, entity.getProjection(), Optional.of(Collections.singletonList(id.get()))).getPersistentResources();
        PersistentResource updatedResource = loadedResource.iterator().next();
        return this.updateAttributes(updatedResource, entity, attributes);
    }

    private PersistentResource<?> updateAttributes(PersistentResource<?> toUpdate, Entity entity, Set<Entity.Attribute> attributes) {
        EntityDictionary dictionary = entity.getRequestScope().getDictionary();
        Type<?> entityClass = entity.getEntityClass();
        String idFieldName = dictionary.getIdFieldName(entityClass);
        for (Entity.Attribute attribute : attributes) {
            if (dictionary.isAttribute(entityClass, attribute.getName())) {
                Type attributeType = dictionary.getType(entityClass, attribute.getName());
                Object attributeValue = ClassType.MAP_TYPE.isAssignableFrom(attributeType) ? MapEntryContainer.translateFromGraphQLMap(attribute) : attribute.getValue();
                toUpdate.updateAttribute(attribute.getName(), attributeValue);
                continue;
            }
            if (Objects.equals(attribute.getName(), idFieldName)) continue;
            throw new IllegalStateException("Unrecognized attribute passed to 'data': " + attribute.getName());
        }
        return toUpdate;
    }

    private ConnectionContainer deleteObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("DELETE must not include data argument");
        }
        if (!context.ids.isPresent()) {
            throw new BadRequestException("DELETE must include ids argument");
        }
        ConnectionContainer connection = (ConnectionContainer)this.fetchObjects(context);
        Set<PersistentResource> toDelete = connection.getPersistentResources();
        toDelete.forEach(PersistentResource::deleteResource);
        return new ConnectionContainer(Collections.emptySet(), Optional.empty(), connection.getTypeName());
    }

    private ConnectionContainer removeObjects(Environment context) {
        if (context.data.isPresent()) {
            throw new BadRequestException("REPLACE must not include data argument");
        }
        if (!context.ids.isPresent()) {
            throw new BadRequestException("REPLACE must include ids argument");
        }
        ConnectionContainer connection = (ConnectionContainer)this.fetchObjects(context);
        Set<PersistentResource> toRemove = connection.getPersistentResources();
        if (!context.isRoot()) {
            toRemove.forEach(item -> context.parentResource.removeRelation(context.field.getName(), item));
        } else {
            toRemove.forEach(PersistentResource::deleteResource);
        }
        return new ConnectionContainer(Collections.emptySet(), Optional.empty(), connection.getTypeName());
    }

    private ConnectionContainer replaceObjects(Environment context) {
        if (!context.data.isPresent()) {
            throw new BadRequestException("REPLACE must include data argument");
        }
        if (context.ids.isPresent()) {
            throw new BadRequestException("REPLACE must not include ids argument");
        }
        ConnectionContainer existingObjects = (ConnectionContainer)context.container.processFetch(context);
        ConnectionContainer upsertedObjects = this.upsertObjects(context);
        Sets.SetView toDelete = Sets.difference(existingObjects.getPersistentResources(), upsertedObjects.getPersistentResources());
        if (!context.isRoot()) {
            toDelete.forEach(item -> context.parentResource.removeRelation(context.field.getName(), item));
        } else {
            toDelete.forEach(PersistentResource::deleteResource);
        }
        return upsertedObjects;
    }

    @FunctionalInterface
    private static interface Executor<T> {
        public T execute(Entity var1, Environment var2);
    }
}

