/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.function.Function;

public enum KeyWord {
    NODE("node"),
    EDGES("edges"),
    PAGE_INFO("pageInfo"),
    PAGE_INFO_HAS_NEXT_PAGE("hasNextPage"),
    PAGE_INFO_START_CURSOR("startCursor"),
    PAGE_INFO_END_CURSOR("endCursor"),
    PAGE_INFO_TOTAL_RECORDS("totalRecords"),
    TYPENAME("__typename"),
    SCHEMA("__schema"),
    TYPE("__type"),
    UNKNOWN("unknown");

    private static final ImmutableMap<String, KeyWord> NAME_MAP;
    private final String name;

    private KeyWord(String name) {
        this.name = name;
    }

    public boolean hasName(String name) {
        return this.name.equals(name);
    }

    public static KeyWord byName(String value) {
        return (KeyWord)((Object)NAME_MAP.getOrDefault((Object)value, (Object)UNKNOWN));
    }

    public String getName() {
        return this.name;
    }

    static {
        NAME_MAP = (ImmutableMap)Arrays.stream(KeyWord.values()).collect(ImmutableMap.toImmutableMap(KeyWord::getName, Function.identity()));
    }
}

