/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.Settings;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BasicExceptionMappers;
import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.exceptions.Slf4jExceptionLogger;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.graphql.FilterDialect;
import com.yahoo.elide.graphql.DefaultGraphQLErrorMapper;
import com.yahoo.elide.graphql.DefaultGraphQLExceptionHandler;
import com.yahoo.elide.graphql.GraphQLExceptionHandler;
import java.util.function.Consumer;

public class GraphQLSettings
implements Settings {
    private final boolean enabled;
    private final String path;
    private final Federation federation;
    private final FilterDialect filterDialect;
    private final GraphQLExceptionHandler graphqlExceptionHandler;

    public GraphQLSettings(boolean enabled, String path, Federation federation, FilterDialect filterDialect, GraphQLExceptionHandler graphqlExceptionHandler) {
        this.enabled = enabled;
        this.path = path;
        this.federation = federation;
        this.filterDialect = filterDialect;
        this.graphqlExceptionHandler = graphqlExceptionHandler;
    }

    public GraphQLSettingsBuilder mutate() {
        return (GraphQLSettingsBuilder)((GraphQLSettingsBuilder)((GraphQLSettingsBuilder)((GraphQLSettingsBuilder)((GraphQLSettingsBuilder)new GraphQLSettingsBuilder().enabled(this.enabled)).path(this.path)).filterDialect(this.filterDialect)).federation(newFederation -> newFederation.enabled(this.getFederation().isEnabled()))).graphqlExceptionHandler(this.graphqlExceptionHandler);
    }

    public static GraphQLSettingsBuilder builder() {
        return new GraphQLSettingsBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPath() {
        return this.path;
    }

    public Federation getFederation() {
        return this.federation;
    }

    public FilterDialect getFilterDialect() {
        return this.filterDialect;
    }

    public GraphQLExceptionHandler getGraphqlExceptionHandler() {
        return this.graphqlExceptionHandler;
    }

    public static class Federation {
        private final boolean enabled;

        public Federation(boolean enabled) {
            this.enabled = enabled;
        }

        public static FederationBuilder builder() {
            return new FederationBuilder();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public static class FederationBuilder {
            private boolean enabled = false;

            public FederationBuilder enabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Federation build() {
                return new Federation(this.enabled);
            }
        }
    }

    public static class GraphQLSettingsBuilder
    extends GraphQLSettingsBuilderSupport<GraphQLSettingsBuilder> {
        private Consumer<GraphQLSettingsBuilder> processor = null;

        private GraphQLSettingsBuilder processor(Consumer<GraphQLSettingsBuilder> processor) {
            this.processor = processor;
            return this.self();
        }

        public GraphQLSettings build() {
            if (this.processor != null) {
                this.processor.accept(this);
            }
            return new GraphQLSettings(this.enabled, this.path, this.federation.build(), this.filterDialect, this.graphqlExceptionHandler);
        }

        @Override
        protected GraphQLSettingsBuilder self() {
            return this;
        }

        public static GraphQLSettingsBuilder withDefaults(EntityDictionary entityDictionary) {
            return new GraphQLSettingsBuilder().processor(builder -> {
                if (builder.filterDialect == null) {
                    builder.filterDialect((FilterDialect)RSQLFilterDialect.builder().dictionary(entityDictionary).build());
                }
            });
        }
    }

    public static abstract class GraphQLSettingsBuilderSupport<S>
    implements Settings.SettingsBuilder {
        protected boolean enabled = false;
        protected String path = "/";
        protected final Federation.FederationBuilder federation = Federation.builder();
        protected FilterDialect filterDialect;
        protected GraphQLExceptionHandler graphqlExceptionHandler = new DefaultGraphQLExceptionHandler((ExceptionLogger)new Slf4jExceptionLogger(), (ExceptionMappers)BasicExceptionMappers.builder().build(), new DefaultGraphQLErrorMapper());

        protected abstract S self();

        public S enabled(boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public S path(String path) {
            this.path = path;
            return this.self();
        }

        public S federation(Consumer<Federation.FederationBuilder> federation) {
            federation.accept(this.federation);
            return this.self();
        }

        public S filterDialect(FilterDialect filterDialect) {
            this.filterDialect = filterDialect;
            return this.self();
        }

        public S graphqlExceptionHandler(GraphQLExceptionHandler graphqlExceptionHandler) {
            this.graphqlExceptionHandler = graphqlExceptionHandler;
            return this.self();
        }
    }
}

