/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLScalars {
    private static final Logger log = LoggerFactory.getLogger(GraphQLScalars.class);
    private static final String ERROR_BAD_EPOCH_TYPE = "Date must be provided as string or integral in epoch millis";
    public static GraphQLScalarType GRAPHQL_DATE_TYPE = GraphQLScalarType.newScalar().name("Date").description("Built-in date").coercing((Coercing)new Coercing<Date, Object>(){

        public Object serialize(Object o) {
            Serde dateSerde = CoerceUtil.lookup(Date.class);
            return dateSerde.serialize((Object)((Date)o));
        }

        public Date parseValue(Object o) {
            Serde dateSerde = CoerceUtil.lookup(Date.class);
            return (Date)dateSerde.deserialize(Date.class, o);
        }

        public Date parseLiteral(Object o) {
            Object input;
            if (o instanceof IntValue) {
                input = ((IntValue)o).getValue().longValue();
            } else if (o instanceof StringValue) {
                input = ((StringValue)o).getValue();
            } else {
                throw new CoercingParseValueException(GraphQLScalars.ERROR_BAD_EPOCH_TYPE);
            }
            return this.parseValue(input);
        }
    }).build();
    public static GraphQLScalarType GRAPHQL_DEFERRED_ID = GraphQLScalarType.newScalar().name("DeferredID").description("custom id type").coercing(new Coercing(){

        public Object serialize(Object o) {
            return o;
        }

        public String parseValue(Object o) {
            return o.toString();
        }

        public String parseLiteral(Object o) {
            if (o instanceof StringValue) {
                return ((StringValue)o).getValue();
            }
            if (o instanceof IntValue) {
                return ((IntValue)o).getValue().toString();
            }
            log.debug("Found unexpected object type: {}", o.getClass());
            return o.toString();
        }
    }).build();
}

