/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.parser.GraphQLProjectionInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class GraphQLRequestScope
extends RequestScope {
    private final Map<String, Long> totalRecordCounts = new HashMap<String, Long>();
    private final GraphQLProjectionInfo projectionInfo;

    public GraphQLRequestScope(Route route, DataStoreTransaction transaction, User user, UUID requestId, ElideSettings elideSettings, Function<RequestScope, EntityProjection> entityProjection, GraphQLProjectionInfo projectionInfo) {
        super(route, transaction, user, requestId, elideSettings, entityProjection);
        this.projectionInfo = projectionInfo;
    }

    public static GraphQLRequestScopeBuilder builder() {
        return new GraphQLRequestScopeBuilder();
    }

    public Map<String, Long> getTotalRecordCounts() {
        return this.totalRecordCounts;
    }

    public GraphQLProjectionInfo getProjectionInfo() {
        return this.projectionInfo;
    }

    public static class GraphQLRequestScopeBuilder
    extends RequestScope.RequestScopeBuilder {
        protected GraphQLProjectionInfo projectionInfo;

        public GraphQLRequestScopeBuilder projectionInfo(GraphQLProjectionInfo projectionInfo) {
            this.projectionInfo = projectionInfo;
            return this;
        }

        public GraphQLRequestScope build() {
            this.applyDefaults();
            return new GraphQLRequestScope(this.route, this.dataStoreTransaction, this.user, this.requestId, this.elideSettings, this.entityProjection, this.projectionInfo);
        }

        public GraphQLRequestScopeBuilder route(Route route) {
            super.route(route);
            return this;
        }

        public GraphQLRequestScopeBuilder dataStoreTransaction(DataStoreTransaction transaction) {
            super.dataStoreTransaction(transaction);
            return this;
        }

        public GraphQLRequestScopeBuilder user(User user) {
            super.user(user);
            return this;
        }

        public GraphQLRequestScopeBuilder requestId(UUID requestId) {
            super.requestId(requestId);
            return this;
        }

        public GraphQLRequestScopeBuilder elideSettings(ElideSettings elideSettings) {
            super.elideSettings(elideSettings);
            return this;
        }

        public GraphQLRequestScopeBuilder entityProjection(Function<RequestScope, EntityProjection> entityProjection) {
            super.entityProjection(entityProjection);
            return this;
        }

        public GraphQLRequestScopeBuilder entityProjection(EntityProjection entityProjection) {
            super.entityProjection(entityProjection);
            return this;
        }
    }
}

