/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.exceptions.ErrorContext;

public class GraphQLErrorContext
implements ErrorContext {
    private final boolean verbose;
    private final ObjectMapper objectMapper;
    private final String graphQLDocument;

    GraphQLErrorContext(boolean verbose, ObjectMapper objectMapper, String graphQLDocument) {
        this.verbose = verbose;
        this.objectMapper = objectMapper;
        this.graphQLDocument = graphQLDocument;
    }

    public static GraphQLErrorContextBuilder builder() {
        return new GraphQLErrorContextBuilder();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getGraphQLDocument() {
        return this.graphQLDocument;
    }

    public static class GraphQLErrorContextBuilder {
        private boolean verbose;
        private ObjectMapper objectMapper;
        private String graphQLDocument;

        GraphQLErrorContextBuilder() {
        }

        public GraphQLErrorContextBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public GraphQLErrorContextBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public GraphQLErrorContextBuilder graphQLDocument(String graphQLDocument) {
            this.graphQLDocument = graphQLDocument;
            return this;
        }

        public GraphQLErrorContext build() {
            return new GraphQLErrorContext(this.verbose, this.objectMapper, this.graphQLDocument);
        }

        public String toString() {
            return "GraphQLErrorContext.GraphQLErrorContextBuilder(verbose=" + this.verbose + ", objectMapper=" + this.objectMapper + ", graphQLDocument=" + this.graphQLDocument + ")";
        }
    }
}

