/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.exceptions.InvalidApiVersionException;
import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.BasicApiVersionValidator;
import com.yahoo.elide.core.request.route.FlexibleRouteResolver;
import com.yahoo.elide.core.request.route.NullRouteResolver;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.jsonapi.resources.SecurityContextUser;
import com.yahoo.elide.utils.HeaderProcessor;
import com.yahoo.elide.utils.ResourceUtils;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Produces(value={"application/json"})
@Path(value="/")
public class GraphQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GraphQLEndpoint.class);
    private final Map<String, QueryRunner> runners;
    private final Elide elide;
    private final HeaderProcessor headerProcessor;
    protected final RouteResolver routeResolver;

    @Inject
    public GraphQLEndpoint(@Named(value="elide") Elide elide, Optional<DataFetcherExceptionHandler> optionalDataFetcherExceptionHandler, Optional<RouteResolver> optionalRouteResolver) {
        log.debug("Started ~~");
        this.elide = elide;
        this.headerProcessor = elide.getElideSettings().getHeaderProcessor();
        this.runners = new HashMap<String, QueryRunner>();
        for (String apiVersion : elide.getElideSettings().getEntityDictionary().getApiVersions()) {
            this.runners.put(apiVersion, new QueryRunner(elide, apiVersion, optionalDataFetcherExceptionHandler.orElseGet(SimpleDataFetcherExceptionHandler::new)));
        }
        this.routeResolver = optionalRouteResolver.orElseGet(() -> {
            Set apiVersions = elide.getElideSettings().getEntityDictionary().getApiVersions();
            if (apiVersions.size() == 1 && apiVersions.contains("")) {
                return new NullRouteResolver();
            }
            return new FlexibleRouteResolver((ApiVersionValidator)new BasicApiVersionValidator(), () -> ((ElideSettings)elide.getElideSettings()).getBaseUrl());
        });
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"application/json"})
    public Response post(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String graphQLDocument) {
        String pathname;
        Map requestHeaders = this.headerProcessor.process((Map)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        String baseUrl = this.getBaseUrlEndpoint(uriInfo);
        Route route = this.routeResolver.resolve("application/json", baseUrl, pathname = path, requestHeaders, (Map)uriInfo.getQueryParameters());
        QueryRunner runner = this.runners.getOrDefault(route.getApiVersion(), null);
        ElideResponse<String> response = runner == null ? QueryRunner.handleRuntimeException(this.elide, (RuntimeException)new InvalidApiVersionException("Invalid API Version")) : runner.run(route.getBaseUrl(), graphQLDocument, (User)user, UUID.randomUUID(), requestHeaders);
        return Response.status((int)response.getStatus()).entity(response.getBody()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response post(@Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String graphQLDocument) {
        return this.post("", uriInfo, headers, securityContext, graphQLDocument);
    }

    protected String getBaseUrlEndpoint(UriInfo uriInfo) {
        String path;
        String baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ResourceUtils.resolveBaseUrl((UriInfo)uriInfo);
        }
        if ((path = uriInfo.getBaseUri().getPath()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return baseUrl + path;
    }
}

