/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.graphql.GraphQLNameUtils;
import com.yahoo.elide.graphql.GraphQLScalars;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.SerdeCoercing;
import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.scalars.java.JavaPrimitives;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLConversionUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphQLConversionUtils.class);
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String ERROR_MESSAGE = "Value should either be integer, String or float";
    private final Map<Type<?>, GraphQLScalarType> scalarMap = new HashMap();
    protected NonEntityDictionary nonEntityDictionary;
    protected EntityDictionary entityDictionary;
    private final Map<Type, GraphQLObjectType> outputConversions = new HashMap<Type, GraphQLObjectType>();
    private final Map<Type, GraphQLInputObjectType> inputConversions = new HashMap<Type, GraphQLInputObjectType>();
    private final Map<Type, GraphQLEnumType> enumConversions = new HashMap<Type, GraphQLEnumType>();
    private final Map<String, GraphQLEnumType> namedEnumConversions = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLList> mapConversions = new HashMap<String, GraphQLList>();
    private final GraphQLNameUtils nameUtils;

    public GraphQLConversionUtils(EntityDictionary entityDictionary, NonEntityDictionary nonEntityDictionary) {
        this.entityDictionary = entityDictionary;
        this.nonEntityDictionary = nonEntityDictionary;
        this.nameUtils = new GraphQLNameUtils(entityDictionary);
        this.registerCustomScalars();
    }

    private void registerCustomScalars() {
        CoerceUtil.getSerdes().forEach((type, serde) -> {
            SerdeCoercing serdeCoercing = new SerdeCoercing(ERROR_MESSAGE, serde, (Class<?>)type);
            ElideTypeConverter elideTypeConverter = serde.getClass().getAnnotation(ElideTypeConverter.class);
            String name = elideTypeConverter != null ? elideTypeConverter.name() : type.getSimpleName();
            String description = elideTypeConverter != null ? elideTypeConverter.description() : type.getSimpleName();
            this.scalarMap.put((Type<?>)ClassType.of((Class)type), GraphQLScalarType.newScalar().name(name).description(description).coercing(serdeCoercing).build());
        });
    }

    public GraphQLScalarType classToScalarType(Type<?> clazz) {
        if (clazz.equals((Object)ClassType.of(Integer.TYPE)) || clazz.equals((Object)ClassType.of(Integer.class))) {
            return Scalars.GraphQLInt;
        }
        if (clazz.equals((Object)ClassType.of(Boolean.TYPE)) || clazz.equals((Object)ClassType.of(Boolean.class))) {
            return Scalars.GraphQLBoolean;
        }
        if (clazz.equals((Object)ClassType.of(Long.TYPE)) || clazz.equals((Object)ClassType.of(Long.class))) {
            return ExtendedScalars.GraphQLBigInteger;
        }
        if (clazz.equals((Object)ClassType.of(Float.TYPE)) || clazz.equals((Object)ClassType.of(Float.class))) {
            return Scalars.GraphQLFloat;
        }
        if (clazz.equals((Object)ClassType.of(Double.TYPE)) || clazz.equals((Object)ClassType.of(Double.class))) {
            return ExtendedScalars.GraphQLBigDecimal;
        }
        if (clazz.equals((Object)ClassType.of(Short.TYPE)) || clazz.equals((Object)ClassType.of(Short.class))) {
            return Scalars.GraphQLInt;
        }
        if (clazz.equals((Object)ClassType.of(String.class)) || clazz.equals((Object)ClassType.of(Object.class))) {
            return Scalars.GraphQLString;
        }
        if (clazz.equals((Object)ClassType.of(BigDecimal.class))) {
            return JavaPrimitives.GraphQLBigDecimal;
        }
        return this.otherClassToScalarType(clazz);
    }

    private GraphQLScalarType otherClassToScalarType(Type<?> clazz) {
        if (this.scalarMap.containsKey(clazz)) {
            return this.scalarMap.get(clazz);
        }
        if (ClassType.DATE_TYPE.isAssignableFrom(clazz)) {
            return GraphQLScalars.GRAPHQL_DATE_TYPE;
        }
        return null;
    }

    public GraphQLEnumType classToEnumType(Type<?> enumClazz) {
        if (this.enumConversions.containsKey(enumClazz)) {
            return this.enumConversions.get(enumClazz);
        }
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(this.nameUtils.toOutputTypeName(enumClazz));
        for (Enum value : values) {
            builder.value(value.toString(), (Object)value);
        }
        GraphQLEnumType enumResult = builder.build();
        this.enumConversions.put(enumClazz, enumResult);
        return enumResult;
    }

    public GraphQLEnumType classToNamedEnumType(Type<?> enumClazz, Function<String, String> nameProcessor, Predicate<Enum<?>> filter) {
        String name = nameProcessor.apply(this.nameUtils.toOutputTypeName(enumClazz));
        if (this.namedEnumConversions.containsKey(name)) {
            return this.namedEnumConversions.get(name);
        }
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(name);
        for (Enum value : values) {
            if (!filter.test(value)) continue;
            builder.value(value.toString(), (Object)value);
        }
        GraphQLEnumType enumResult = builder.build();
        this.namedEnumConversions.put(name, enumResult);
        return enumResult;
    }

    public GraphQLList classToQueryMap(Type<?> keyClazz, Type<?> valueClazz, DataFetcher fetcher) {
        String mapName = this.nameUtils.toMapEntryOutputName(keyClazz, valueClazz);
        if (this.mapConversions.containsKey(mapName)) {
            return this.mapConversions.get(mapName);
        }
        GraphQLOutputType keyType = this.fetchScalarOrObjectOutput(keyClazz, fetcher);
        GraphQLOutputType valueType = this.fetchScalarOrObjectOutput(valueClazz, fetcher);
        GraphQLObjectType mapType = GraphQLObjectType.newObject().name(mapName).field(GraphQLFieldDefinition.newFieldDefinition().name(KEY).type(keyType)).field(GraphQLFieldDefinition.newFieldDefinition().name(VALUE).type(valueType)).build();
        GraphQLList outputMap = new GraphQLList((GraphQLType)mapType);
        this.mapConversions.put(mapName, outputMap);
        return this.mapConversions.get(mapName);
    }

    public GraphQLList classToInputMap(Type<?> keyClazz, Type<?> valueClazz) {
        String mapName = this.nameUtils.toMapEntryInputName(keyClazz, valueClazz);
        if (this.mapConversions.containsKey(mapName)) {
            return this.mapConversions.get(mapName);
        }
        GraphQLInputType keyType = this.fetchScalarOrObjectInput(keyClazz);
        GraphQLInputType valueType = this.fetchScalarOrObjectInput(valueClazz);
        GraphQLList inputMap = new GraphQLList((GraphQLType)GraphQLInputObjectType.newInputObject().name(mapName).field(GraphQLInputObjectField.newInputObjectField().name(KEY).type(keyType)).field(GraphQLInputObjectField.newInputObjectField().name(VALUE).type(valueType)).build());
        this.mapConversions.put(mapName, inputMap);
        return inputMap;
    }

    public GraphQLOutputType attributeToQueryObject(Type<?> parentClass, Type<?> attributeClass, String attribute, DataFetcher fetcher) {
        return this.attributeToQueryObject(parentClass, attributeClass, attribute, fetcher, this.entityDictionary);
    }

    protected GraphQLOutputType attributeToQueryObject(Type<?> parentClass, Type<?> attributeClass, String attribute, DataFetcher fetcher, EntityDictionary dictionary) {
        if (this.outputConversions.containsKey(attributeClass)) {
            return (GraphQLOutputType)this.outputConversions.get(attributeClass);
        }
        if (this.enumConversions.containsKey(attributeClass)) {
            return (GraphQLOutputType)this.enumConversions.get(attributeClass);
        }
        if (ClassType.CLASS_TYPE.isAssignableFrom(attributeClass)) {
            return null;
        }
        if (ClassType.MAP_TYPE.isAssignableFrom(attributeClass)) {
            Type keyType = dictionary.getParameterizedType(parentClass, attribute, 0);
            Type valueType = dictionary.getParameterizedType(parentClass, attribute, 1);
            return this.classToQueryMap(keyType, valueType, fetcher);
        }
        if (ClassType.COLLECTION_TYPE.isAssignableFrom(attributeClass)) {
            Type listType = dictionary.getParameterizedType(parentClass, attribute, 0);
            return new GraphQLList((GraphQLType)this.fetchScalarOrObjectOutput(listType, fetcher));
        }
        return this.fetchScalarOrObjectOutput(attributeClass, fetcher);
    }

    public GraphQLInputType attributeToInputObject(Type<?> parentClass, Type<?> attributeClass, String attribute) {
        return this.attributeToInputObject(parentClass, attributeClass, attribute, this.entityDictionary);
    }

    protected GraphQLInputType attributeToInputObject(Type<?> parentClass, Type<?> attributeClass, String attribute, EntityDictionary dictionary) {
        if (this.inputConversions.containsKey(attributeClass)) {
            return (GraphQLInputType)this.inputConversions.get(attributeClass);
        }
        if (this.enumConversions.containsKey(attributeClass)) {
            return (GraphQLInputType)this.enumConversions.get(attributeClass);
        }
        if (ClassType.CLASS_TYPE.isAssignableFrom(attributeClass)) {
            return null;
        }
        if (ClassType.MAP_TYPE.isAssignableFrom(attributeClass)) {
            Type keyType = dictionary.getParameterizedType(parentClass, attribute, 0);
            Type valueType = dictionary.getParameterizedType(parentClass, attribute, 1);
            return this.classToInputMap(keyType, valueType);
        }
        if (ClassType.COLLECTION_TYPE.isAssignableFrom(attributeClass)) {
            Type listType = dictionary.getParameterizedType(parentClass, attribute, 0);
            return new GraphQLList((GraphQLType)this.fetchScalarOrObjectInput(listType));
        }
        return this.fetchScalarOrObjectInput(attributeClass);
    }

    public GraphQLObjectType classToQueryObject(Type<?> clazz, DataFetcher fetcher) {
        log.info("Building query object for type: {}", (Object)clazz.getName());
        if (!this.nonEntityDictionary.hasBinding(clazz)) {
            this.nonEntityDictionary.bindEntity(clazz);
        }
        if (this.outputConversions.containsKey(clazz)) {
            return this.outputConversions.get(clazz);
        }
        GraphQLObjectType.Builder objectBuilder = GraphQLObjectType.newObject();
        objectBuilder.name(this.nameUtils.toNonElideOutputTypeName(clazz));
        for (String attribute : this.nonEntityDictionary.getAttributes(clazz)) {
            Type attributeClass = this.nonEntityDictionary.getType(clazz, attribute);
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(attribute);
            GraphQLOutputType attributeType = this.attributeToQueryObject(clazz, attributeClass, attribute, fetcher, this.nonEntityDictionary);
            if (attributeType == null) continue;
            fieldBuilder.type(attributeType);
            objectBuilder.field(fieldBuilder);
        }
        GraphQLObjectType object = objectBuilder.build();
        this.outputConversions.put(clazz, object);
        return object;
    }

    public GraphQLInputObjectType classToInputObject(Type<?> clazz) {
        log.info("Building input object for type: {}", (Object)clazz.getName());
        if (!this.nonEntityDictionary.hasBinding(clazz)) {
            this.nonEntityDictionary.bindEntity(clazz);
        }
        if (this.inputConversions.containsKey(clazz)) {
            return this.inputConversions.get(clazz);
        }
        GraphQLInputObjectType.Builder objectBuilder = GraphQLInputObjectType.newInputObject();
        objectBuilder.name(this.nameUtils.toNonElideInputTypeName(clazz));
        for (String attribute : this.nonEntityDictionary.getAttributes(clazz)) {
            log.info("Building input object attribute: {}", (Object)attribute);
            Type attributeClass = this.nonEntityDictionary.getType(clazz, attribute);
            GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField().name(attribute);
            GraphQLInputType attributeType = this.attributeToInputObject(clazz, attributeClass, attribute, this.nonEntityDictionary);
            if (attributeType == null) continue;
            fieldBuilder.type(attributeType);
            objectBuilder.field(fieldBuilder);
        }
        GraphQLInputObjectType object = objectBuilder.build();
        this.inputConversions.put(clazz, object);
        return object;
    }

    public List<GraphQLArgument> attributeArgumentToQueryObject(Type<?> entityClass, String attribute, DataFetcher fetcher) {
        return this.attributeArgumentToQueryObject(entityClass, attribute, fetcher, this.entityDictionary);
    }

    public List<GraphQLArgument> attributeArgumentToQueryObject(Type<?> entityClass, String attribute, DataFetcher fetcher, EntityDictionary dictionary) {
        return dictionary.getAttributeArguments(entityClass, attribute).stream().map(argumentType -> GraphQLArgument.newArgument().name(argumentType.getName()).type(this.fetchScalarOrObjectInput(argumentType.getType())).defaultValue(argumentType.getDefaultValue()).build()).collect(Collectors.toList());
    }

    public List<GraphQLArgument> entityArgumentToQueryObject(Type<?> entityClass, EntityDictionary dictionary) {
        return dictionary.getEntityArguments(entityClass).stream().map(argumentType -> GraphQLArgument.newArgument().name(argumentType.getName()).type(this.fetchScalarOrObjectInput(argumentType.getType())).defaultValue(argumentType.getDefaultValue()).build()).collect(Collectors.toList());
    }

    private GraphQLOutputType fetchScalarOrObjectOutput(Type<?> conversionClass, DataFetcher fetcher) {
        if (conversionClass.isEnum()) {
            return this.classToEnumType(conversionClass);
        }
        GraphQLScalarType outputType = this.classToScalarType(conversionClass);
        if (outputType == null) {
            outputType = this.classToQueryObject(conversionClass, fetcher);
        }
        return outputType;
    }

    private GraphQLInputType fetchScalarOrObjectInput(Type<?> conversionClass) {
        if (conversionClass.isEnum()) {
            return this.classToEnumType(conversionClass);
        }
        GraphQLScalarType inputType = this.classToScalarType(conversionClass);
        if (inputType == null) {
            inputType = this.classToInputObject(conversionClass);
        }
        return inputType;
    }

    public Set<GraphQLObjectType> getObjectTypes() {
        Set<GraphQLObjectType> allObjects = this.mapConversions.values().stream().map(GraphQLList::getWrappedType).filter(type -> type instanceof GraphQLObjectType).map(GraphQLObjectType.class::cast).collect(Collectors.toSet());
        allObjects.addAll(this.outputConversions.values());
        return allObjects;
    }
}

