/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yahoo.elide.ElideError;
import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.ElideErrors;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.ErrorContext;
import com.yahoo.elide.core.exceptions.ExceptionHandlerSupport;
import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidApiVersionException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.graphql.GraphQLErrorContext;
import com.yahoo.elide.graphql.GraphQLErrorMapper;
import com.yahoo.elide.graphql.GraphQLExceptionHandler;
import com.yahoo.elide.graphql.models.GraphQLErrors;
import graphql.GraphQLException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphQLExceptionHandler
extends ExceptionHandlerSupport<GraphQLErrorContext>
implements GraphQLExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultGraphQLExceptionHandler.class);
    protected GraphQLErrorMapper graphqlErrorMapper;

    public DefaultGraphQLExceptionHandler(ExceptionLogger exceptionLogger, ExceptionMappers exceptionMappers, GraphQLErrorMapper graphqlErrorMapper) {
        super(exceptionLogger, exceptionMappers);
        this.graphqlErrorMapper = graphqlErrorMapper;
    }

    protected ElideResponse<?> handleRuntimeException(RuntimeException exception, GraphQLErrorContext errorContext) {
        if (exception instanceof GraphQLException) {
            GraphQLException e = (GraphQLException)exception;
            String body = e.getMessage();
            return ElideResponse.status((int)200).body((Object)body);
        }
        if (exception instanceof InvalidEntityBodyException) {
            InvalidEntityBodyException e = (InvalidEntityBodyException)exception;
            if (e.getCause() instanceof JsonParseException) {
                return this.buildResponse((HttpStatusException)e, errorContext);
            }
            return this.buildResponse(200, (HttpStatusException)e, errorContext);
        }
        if (exception instanceof InvalidApiVersionException) {
            InvalidApiVersionException e = (InvalidApiVersionException)exception;
            return this.buildResponse((HttpStatusException)e, errorContext);
        }
        if (exception instanceof HttpStatusException) {
            HttpStatusException e = (HttpStatusException)exception;
            return this.buildResponse(200, e, errorContext);
        }
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)exception;
            GraphQLErrors.GraphQLErrorsBuilder errors = GraphQLErrors.builder();
            if (e.getConstraintViolations() != null) {
                for (ConstraintViolation constraintViolation : e.getConstraintViolations()) {
                    errors.error(error -> {
                        error.message(constraintViolation.getMessage(), new Object[0]);
                        error.extension("code", constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName());
                        error.extension("type", "ConstraintViolation");
                        String propertyPathString = constraintViolation.getPropertyPath().toString();
                        if (!propertyPathString.isEmpty()) {
                            error.extension("property", propertyPathString);
                        }
                    });
                }
            }
            return this.buildResponse(200, errors.build());
        }
        log.error("Error or exception uncaught by Elide", (Throwable)exception);
        throw exception;
    }

    protected ElideResponse<?> handleNonRuntimeException(Exception exception, GraphQLErrorContext errorContext) {
        if (exception instanceof JsonProcessingException) {
            return this.buildResponse((HttpStatusException)new InvalidEntityBodyException(errorContext.getGraphQLDocument()), errorContext);
        }
        if (exception instanceof IOException) {
            return this.buildResponse((HttpStatusException)new TransactionException((Throwable)exception), errorContext);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)exception);
        if (exception instanceof IOException) {
            IOException e = (IOException)exception;
            throw new UncheckedIOException(e);
        }
        throw new RuntimeException(exception);
    }

    protected ElideResponse<?> buildResponse(ElideErrorResponse<?> errorResponse) {
        Object object = errorResponse.getBody();
        if (object instanceof ElideErrors) {
            ElideErrors errors = (ElideErrors)object;
            GraphQLErrors.GraphQLErrorsBuilder builder = GraphQLErrors.builder();
            for (ElideError error : errors.getErrors()) {
                builder.error(this.graphqlErrorMapper.toGraphQLError(error));
            }
            return this.buildResponse(errorResponse.getStatus(), builder.build());
        }
        return this.buildResponse(errorResponse.getStatus(), errorResponse.getBody());
    }

    protected ElideResponse<?> buildResponse(int status, Object body) {
        return new ElideResponse(status, body);
    }

    protected ElideResponse<?> buildResponse(int status, HttpStatusException exception, GraphQLErrorContext errorContext) {
        return ElideResponse.status((int)status).body(super.buildResponse(exception, (ErrorContext)errorContext).getBody());
    }
}

