/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.ElideError;
import com.yahoo.elide.graphql.GraphQLErrorMapper;
import com.yahoo.elide.graphql.models.GraphQLError;
import graphql.ErrorClassification;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultGraphQLErrorMapper
implements GraphQLErrorMapper {
    @Override
    public graphql.GraphQLError toGraphQLError(ElideError error) {
        GraphQLError.GraphQLErrorBuilder graphqlError = GraphQLError.builder();
        if (error.getMessage() != null) {
            graphqlError.message(error.getMessage(), new Object[0]);
        }
        if (error.getAttributes() != null && !error.getAttributes().isEmpty()) {
            ArrayList<SourceLocation> result;
            Object path;
            LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>(error.getAttributes());
            Object object = this.attribute("classification", extensions);
            if (object instanceof String) {
                String classification = (String)object;
                graphqlError.errorType(ErrorClassification.errorClassification((String)classification));
            }
            if ((path = this.attribute("path", extensions)) instanceof List) {
                List list = (List)path;
                result = new ArrayList<SourceLocation>();
                list.forEach(result::add);
                graphqlError.path(result);
            } else if (path instanceof ResultPath) {
                ResultPath resultPath = (ResultPath)path;
                graphqlError.path(resultPath);
            }
            Object locations = this.attribute("locations", extensions);
            if (locations instanceof List) {
                List list = (List)locations;
                result = new ArrayList();
                for (Object item : list) {
                    if (!(item instanceof SourceLocation)) continue;
                    SourceLocation sourceLocation = (SourceLocation)item;
                    result.add(sourceLocation);
                }
                graphqlError.locations(result);
            }
            if (!extensions.isEmpty()) {
                graphqlError.extensions(extensions);
            }
        }
        return graphqlError.build();
    }

    private Object attribute(String key, Map<String, Object> map) {
        if (map.containsKey(key)) {
            Object result = map.get(key);
            map.remove(key);
            return result;
        }
        return null;
    }
}

