/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.multiplex;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.multiplex.MultiplexManager;
import com.yahoo.elide.datastores.multiplex.MultiplexTransaction;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MultiplexWriteTransaction
extends MultiplexTransaction {
    private static final Object NEWLY_CREATED_OBJECT = new Object();
    private final IdentityHashMap<Object, Object> clonedObjects = new IdentityHashMap();
    private final MultivaluedHashMap<DataStore, Object> dirtyObjects = new MultivaluedHashMap();

    public MultiplexWriteTransaction(MultiplexManager multiplexManager) {
        super(multiplexManager);
    }

    @Override
    protected DataStoreTransaction beginTransaction(DataStore dataStore) {
        return dataStore.beginTransaction();
    }

    public <T> void save(T entity, RequestScope requestScope) {
        Type entityType = EntityDictionary.getType(entity);
        this.getTransaction(entityType).save(entity, requestScope);
        this.dirtyObjects.add((Object)this.multiplexManager.getSubManager(entityType), entity);
    }

    public <T> void delete(T entity, RequestScope requestScope) {
        Type entityType = EntityDictionary.getType(entity);
        this.getTransaction(entityType).delete(entity, requestScope);
        this.dirtyObjects.add((Object)this.multiplexManager.getSubManager(entityType), entity);
    }

    @Override
    public void commit(RequestScope scope) {
        this.flush(scope);
        ArrayList<DataStore> commitList = new ArrayList<DataStore>();
        ListIterator iterator = new ArrayList(this.transactions.entrySet()).listIterator(this.transactions.size());
        while (iterator.hasPrevious()) {
            Map.Entry entry = iterator.previous();
            try {
                ((DataStoreTransaction)entry.getValue()).commit(scope);
                if (!this.multiplexManager.isApplyCompensatingTransactions((DataStore)entry.getKey())) continue;
                commitList.add((DataStore)entry.getKey());
            }
            catch (HttpStatusException | WebApplicationException e) {
                this.reverseTransactions(commitList, e, scope);
                throw e;
            }
            catch (Error | RuntimeException e) {
                TransactionException transactionException = new TransactionException(e);
                this.reverseTransactions(commitList, (Throwable)transactionException, scope);
                throw transactionException;
            }
        }
    }

    private void reverseTransactions(List<DataStore> restoreList, Throwable cause, RequestScope requestScope) {
        for (DataStore dataStore : restoreList) {
            try {
                DataStoreTransaction transaction = dataStore.beginTransaction();
                try {
                    List list = this.dirtyObjects.get((Object)dataStore);
                    for (Object dirtyObject : list == null ? Collections.emptyList() : list) {
                        Object cloned = this.clonedObjects.get(dirtyObject);
                        if (cloned == NEWLY_CREATED_OBJECT) {
                            transaction.delete(dirtyObject, requestScope);
                            continue;
                        }
                        if (cloned == null) continue;
                        transaction.save(cloned, requestScope);
                    }
                    transaction.commit(requestScope);
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
            catch (IOException | RuntimeException e) {
                cause.addSuppressed(e);
            }
        }
    }

    @Override
    public <T> void createObject(T entity, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(EntityDictionary.getType(entity));
        transaction.createObject(entity, scope);
        this.clonedObjects.put(entity, NEWLY_CREATED_OBJECT);
    }

    private <T> DataStoreIterable<T> hold(DataStoreTransaction transaction, DataStoreIterable<T> list) {
        ArrayList newList = new ArrayList();
        list.forEach(newList::add);
        for (Object object : newList) {
            this.hold(transaction, object);
        }
        return new DataStoreIterableBuilder(newList).paginateInMemory(list.needsInMemoryPagination()).filterInMemory(list.needsInMemoryFilter()).sortInMemory(list.needsInMemorySort()).build();
    }

    private <T> T hold(DataStoreTransaction subTransaction, T object) {
        this.clonedObjects.put(object, this.cloneObject(object));
        return object;
    }

    private Object cloneObject(Object object) {
        if (object == null) {
            return null;
        }
        Type cls = this.multiplexManager.getDictionary().lookupBoundClass(EntityDictionary.getType((Object)object));
        return this.multiplexManager.objectCloner.clone(object, cls);
    }

    @Override
    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(projection.getType());
        return (T)this.hold(transaction, transaction.loadObject(projection, id, scope));
    }

    @Override
    public <T> DataStoreIterable<T> loadObjects(EntityProjection projection, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(projection.getType());
        return this.hold(transaction, (T)transaction.loadObjects(projection, scope));
    }

    @Override
    public <T, R> DataStoreIterable<R> getToManyRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(EntityDictionary.getType(entity));
        DataStoreIterable relation = super.getToManyRelation(relationTx, entity, relationship, scope);
        return this.hold(transaction, (T)relation);
    }

    @Override
    public <T, R> R getToOneRelation(DataStoreTransaction relationTx, T entity, Relationship relationship, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(EntityDictionary.getType(entity));
        Object relation = super.getToOneRelation(relationTx, entity, relationship, scope);
        return this.hold(transaction, relation);
    }
}

