/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.multiplex;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.multiplex.MultiplexManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;

public abstract class MultiplexTransaction
implements DataStoreTransaction {
    protected LinkedHashMap<DataStore, DataStoreTransaction> transactions;
    protected final MultiplexManager multiplexManager;

    public MultiplexTransaction(MultiplexManager multiplexManager) {
        this.multiplexManager = multiplexManager;
        this.transactions = new LinkedHashMap(multiplexManager.dataStores.size());
    }

    protected abstract DataStoreTransaction beginTransaction(DataStore var1);

    public <T> void createObject(T entity, RequestScope scope) {
        this.getTransaction(EntityDictionary.getType(entity)).createObject(entity, scope);
    }

    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        return (T)this.getTransaction(projection.getType()).loadObject(projection, id, scope);
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection projection, RequestScope scope) {
        return this.getTransaction(projection.getType()).loadObjects(projection, scope);
    }

    public void flush(RequestScope scope) {
        this.processTransactions(dataStoreTransaction -> dataStoreTransaction.flush(scope));
    }

    public void preCommit(RequestScope scope) {
        this.processTransactions(dataStoreTransaction -> dataStoreTransaction.preCommit(scope));
    }

    public void commit(RequestScope scope) {
        this.flush(scope);
        this.processTransactions(dataStoreTransaction -> dataStoreTransaction.commit(scope));
    }

    protected void processTransactions(Consumer<DataStoreTransaction> processor) {
        ListIterator<DataStoreTransaction> iterator = new ArrayList<DataStoreTransaction>(this.transactions.values()).listIterator(this.transactions.size());
        while (iterator.hasPrevious()) {
            DataStoreTransaction dataStoreTransaction = iterator.previous();
            if (dataStoreTransaction == null) continue;
            processor.accept(dataStoreTransaction);
        }
    }

    public void close() throws IOException {
        Throwable cause = null;
        ListIterator<DataStoreTransaction> iterator = new ArrayList<DataStoreTransaction>(this.transactions.values()).listIterator(this.transactions.size());
        while (iterator.hasPrevious()) {
            DataStoreTransaction dataStoreTransaction = iterator.previous();
            if (dataStoreTransaction == null) continue;
            try {
                dataStoreTransaction.close();
            }
            catch (IOException | Error | RuntimeException e) {
                if (cause != null) {
                    cause.addSuppressed(e);
                    continue;
                }
                if (e instanceof IOException) {
                    IOException ioException = (IOException)e;
                    cause = ioException;
                    continue;
                }
                cause = new IOException(e);
            }
        }
        this.transactions.clear();
        if (cause != null) {
            throw cause;
        }
    }

    protected DataStoreTransaction getTransaction(Object object) {
        return this.getTransaction((Type<?>)ClassType.of(object.getClass()));
    }

    protected DataStoreTransaction getTransaction(Type<?> cls) {
        DataStore lookupDataStore = this.multiplexManager.getSubManager(cls);
        DataStoreTransaction transaction = this.transactions.get(lookupDataStore);
        if (transaction == null) {
            for (DataStore dataStore : this.multiplexManager.dataStores) {
                if (!dataStore.equals(lookupDataStore)) continue;
                transaction = this.beginTransaction(dataStore);
                this.transactions.put(dataStore, transaction);
                break;
            }
            if (transaction == null) {
                throw new InvalidCollectionException(cls.getName());
            }
        }
        return transaction;
    }

    protected DataStoreTransaction getRelationTransaction(Object object, String relationName) {
        EntityDictionary dictionary = this.multiplexManager.getDictionary();
        Type relationClass = dictionary.getParameterizedType(EntityDictionary.getType((Object)object), relationName);
        return this.getTransaction(relationClass);
    }

    public <T, R> DataStoreIterable<R> getToManyRelation(DataStoreTransaction tx, T entity, Relationship relation, RequestScope scope) {
        DataStoreTransaction relationTx = this.getRelationTransaction(entity, relation.getName());
        Type entityType = EntityDictionary.getType(entity);
        DataStoreTransaction entityTransaction = this.getTransaction(entityType);
        return entityTransaction.getToManyRelation(relationTx, entity, relation, scope);
    }

    public <T, R> R getToOneRelation(DataStoreTransaction tx, T entity, Relationship relation, RequestScope scope) {
        DataStoreTransaction relationTx = this.getRelationTransaction(entity, relation.getName());
        Type entityType = EntityDictionary.getType(entity);
        DataStoreTransaction entityTransaction = this.getTransaction(entityType);
        return (R)entityTransaction.getToOneRelation(relationTx, entity, relation, scope);
    }

    public <T, R> void updateToManyRelation(DataStoreTransaction tx, T entity, String relationName, Set<R> newRelationships, Set<R> deletedRelationships, RequestScope scope) {
        DataStoreTransaction relationTx = this.getRelationTransaction(entity, relationName);
        DataStoreTransaction entityTransaction = this.getTransaction(EntityDictionary.getType(entity));
        entityTransaction.updateToManyRelation(relationTx, entity, relationName, newRelationships, deletedRelationships, scope);
    }

    public <T, R> void updateToOneRelation(DataStoreTransaction tx, T entity, String relationName, R relationshipValue, RequestScope scope) {
        DataStoreTransaction relationTx = this.getRelationTransaction(entity, relationName);
        DataStoreTransaction entityTransaction = this.getTransaction(EntityDictionary.getType(entity));
        entityTransaction.updateToOneRelation(relationTx, entity, relationName, relationshipValue, scope);
    }

    public <T, R> R getAttribute(T entity, Attribute attribute, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(EntityDictionary.getType(entity));
        return (R)transaction.getAttribute(entity, attribute, scope);
    }

    public <T> void setAttribute(T entity, Attribute attribute, RequestScope scope) {
        DataStoreTransaction transaction = this.getTransaction(EntityDictionary.getType(entity));
        transaction.setAttribute(entity, attribute, scope);
    }

    private Serializable extractId(FilterExpression filterExpression, String idFieldName, Type<?> relationClass) {
        Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)new PredicateExtractionVisitor());
        return predicates.stream().filter(p -> p.getEntityType() == relationClass && p.getOperator() == Operator.IN).filter(p -> p.getValues().size() == 1).filter(p -> p.getField().equals(idFieldName)).findFirst().map(p -> (Serializable)p.getValues().get(0)).orElse(null);
    }

    public void cancel(RequestScope scope) {
        this.transactions.values().forEach(dataStoreTransaction -> dataStoreTransaction.cancel(scope));
    }

    public <T> T getProperty(String propertyName) {
        DataStore matchingStore = this.multiplexManager.dataStores.stream().filter(store -> propertyName.startsWith(store.getClass().getPackage().getName())).findFirst().orElse(null);
        if (matchingStore == null) {
            return null;
        }
        if (!this.transactions.containsKey(matchingStore)) {
            DataStoreTransaction tx = this.beginTransaction(matchingStore);
            this.transactions.put(matchingStore, tx);
        }
        return (T)this.transactions.get(matchingStore).getProperty(propertyName);
    }
}

