/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.multiplex;

import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ObjectCloner;
import com.yahoo.elide.core.utils.ObjectCloners;
import com.yahoo.elide.datastores.multiplex.MultiplexReadTransaction;
import com.yahoo.elide.datastores.multiplex.MultiplexWriteTransaction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MultiplexManager
implements DataStore {
    protected final List<DataStore> dataStores;
    protected final ConcurrentHashMap<Type<?>, DataStore> dataStoreMap = new ConcurrentHashMap();
    protected final Predicate<DataStore> applyCompensatingTransactions;
    protected final ObjectCloner objectCloner;
    private EntityDictionary dictionary;

    public MultiplexManager(DataStore ... dataStores) {
        this(ObjectCloners::clone, (DataStore dataStore) -> true, dataStores);
    }

    public MultiplexManager(ObjectCloner objectCloner, DataStore ... dataStores) {
        this(objectCloner, (DataStore dataStore) -> true, dataStores);
    }

    public MultiplexManager(ObjectCloner objectCloner, Predicate<DataStore> applyCompensatingTransactions, DataStore ... dataStores) {
        this.objectCloner = objectCloner;
        this.dataStores = Arrays.asList(dataStores);
        this.applyCompensatingTransactions = applyCompensatingTransactions;
    }

    protected boolean isApplyCompensatingTransactions(DataStore dataStore) {
        return this.applyCompensatingTransactions.test(dataStore);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        this.dictionary = dictionary;
        for (DataStore dataStore : this.dataStores) {
            EntityDictionary subordinateDictionary = new EntityDictionary(dictionary.getCheckMappings(), dictionary.getRoleChecks(), dictionary.getInjector(), dictionary.getSerdeLookup(), dictionary.getEntitiesToExclude(), dictionary.getScanner());
            dataStore.populateEntityDictionary(subordinateDictionary);
            for (EntityBinding entityBinding : subordinateDictionary.getBindings(false)) {
                this.dataStoreMap.put(entityBinding.entityClass, dataStore);
                dictionary.bindEntity(entityBinding);
                subordinateDictionary.getApiVersions().forEach(dictionary.getApiVersions()::add);
            }
            for (Map.Entry entry : subordinateDictionary.getEntityPermissionExecutor().entrySet()) {
                dictionary.bindPermissionExecutor((Type)entry.getKey(), (Function)entry.getValue());
            }
        }
    }

    public DataStoreTransaction beginTransaction() {
        return new MultiplexWriteTransaction(this);
    }

    public DataStoreTransaction beginReadTransaction() {
        return new MultiplexReadTransaction(this);
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    protected <T> DataStore getSubManager(Type<T> cls) {
        Type type = this.dictionary.lookupBoundClass(cls);
        return this.dataStoreMap.get(type);
    }

    protected void setDictionary(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }
}

