/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms.websocket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.graphql.serialization.GraphQLModule;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Complete;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.ConnectionInit;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Error;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.MessageType;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Next;
import com.yahoo.elide.graphql.subscriptions.websocket.protocol.Subscribe;
import graphql.ExecutionResult;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class SubscriptionWebSocketTestClient {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionWebSocketTestClient.class);
    private CountDownLatch sessionLatch = new CountDownLatch(1);
    private CountDownLatch subscribeLatch = new CountDownLatch(1);
    private ObjectMapper mapper;
    private List<ExecutionResult> results = new ArrayList<ExecutionResult>();
    private Session session;
    private List<String> queries;
    private int expectedNumberOfMessages;
    private int expectedNumberOfSubscribes;
    boolean isOpen = false;

    public SubscriptionWebSocketTestClient(int expectedNumberOfMessages, List<String> queries) {
        this.queries = queries;
        this.expectedNumberOfMessages = expectedNumberOfMessages;
        this.expectedNumberOfSubscribes = queries.size();
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new GraphQLModule());
    }

    @OnOpen
    public void onOpen(Session session) throws Exception {
        this.session = session;
        log.debug("WebSocket opened: " + session.getId());
        this.isOpen = true;
        session.getBasicRemote().sendText(this.mapper.writeValueAsString((Object)new ConnectionInit()));
    }

    @OnMessage
    public void onMessage(String text) throws Exception {
        JsonNode type = this.mapper.readTree(text).get("type");
        MessageType messageType = MessageType.valueOf((String)type.textValue().toUpperCase(Locale.ROOT));
        switch (messageType) {
            case CONNECTION_ACK: {
                Integer id = 1;
                for (String query : this.queries) {
                    Subscribe subscribe = Subscribe.builder().id(id.toString()).payload(Subscribe.Payload.builder().query(query).build()).build();
                    this.session.getBasicRemote().sendText(this.mapper.writeValueAsString((Object)subscribe));
                    Integer n = id;
                    id = id + 1;
                }
                break;
            }
            case NEXT: {
                Next next = (Next)this.mapper.readValue(text, Next.class);
                this.results.add(next.getPayload());
                --this.expectedNumberOfMessages;
                if (this.expectedNumberOfMessages > 0) break;
                this.sessionLatch.countDown();
                break;
            }
            case PING: {
                --this.expectedNumberOfSubscribes;
                if (this.expectedNumberOfSubscribes > 0) break;
                this.subscribeLatch.countDown();
                break;
            }
            case ERROR: {
                Error error = (Error)this.mapper.readValue(text, Error.class);
                log.error("ERROR: {}", (Object[])error.getPayload());
                this.sessionLatch.countDown();
                break;
            }
        }
    }

    @OnClose
    public void onClose(CloseReason reason) throws Exception {
        log.debug("Session closed: " + reason.getCloseCode() + " " + reason.getReasonPhrase());
        this.isOpen = false;
        this.sessionLatch.countDown();
    }

    @OnError
    public void onError(Throwable t) throws Exception {
        log.error("Session error: " + t.getMessage());
        this.isOpen = false;
        this.sessionLatch.countDown();
    }

    public void sendClose() throws Exception {
        if (this.isOpen) {
            Integer id = 1;
            for (String query : this.queries) {
                this.session.getBasicRemote().sendText(this.mapper.writeValueAsString((Object)new Complete(id.toString())));
                Integer n = id;
                id = id + 1;
            }
            this.isOpen = false;
        }
    }

    public List<ExecutionResult> waitOnClose(int waitInSeconds) throws InterruptedException {
        this.sessionLatch.await(waitInSeconds, TimeUnit.SECONDS);
        return this.results;
    }

    public void waitOnSubscribe(int waitInSeconds) throws InterruptedException {
        this.subscribeLatch.await(waitInSeconds, TimeUnit.SECONDS);
    }
}

