/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms.websocket;

import com.fasterxml.jackson.databind.Module;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.ElideSettingsBuilderCustomizer;
import com.yahoo.elide.Settings;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.datastores.jms.JMSDataStore;
import com.yahoo.elide.graphql.GraphQLSettings;
import com.yahoo.elide.graphql.serialization.GraphQLModule;
import com.yahoo.elide.graphql.subscriptions.websocket.SubscriptionWebSocket;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import jakarta.jms.ConnectionFactory;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.net.URI;
import java.security.Principal;
import java.time.Duration;
import java.util.Calendar;
import java.util.Map;

public class SubscriptionWebSocketConfigurator
extends ServerEndpointConfig.Configurator {
    protected ConnectionFactory connectionFactory;
    protected ElideSettingsBuilderCustomizer elideSettingsBuilderCustomizer;
    protected String baseUrl;
    protected Duration connectionTimeout;
    protected int maxSubscriptions;
    private Duration maxIdleTimeout;
    private int maxMessageSize;
    protected SubscriptionWebSocket.UserFactory userFactory;
    protected boolean sendPingOnSubscribe;
    protected DataFetcherExceptionHandler dataFetcherExceptionHandler;
    protected RouteResolver routeResolver;
    protected Injector injector;

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        if (endpointClass.equals(SubscriptionWebSocket.class)) {
            EntityDictionary dictionary = EntityDictionary.builder().injector(this.injector).build();
            DataStore store = this.buildDataStore(dictionary);
            Elide elide = this.buildElide(store, dictionary);
            return endpointClass.cast(this.buildWebSocket(elide));
        }
        return (T)super.getEndpointInstance(endpointClass);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        Principal userPrincipal;
        Object httpSession;
        String queryString;
        Map parameterMap;
        Map headers;
        Map userProperties = sec.getUserProperties();
        URI requestURI = request.getRequestURI();
        if (requestURI != null) {
            userProperties.put("requestURI", requestURI);
        }
        if ((headers = request.getHeaders()) != null) {
            userProperties.put("headers", headers);
        }
        if ((parameterMap = request.getParameterMap()) != null) {
            userProperties.put("parameterMap", parameterMap);
        }
        if ((queryString = request.getQueryString()) != null) {
            userProperties.put("queryString", queryString);
        }
        if ((httpSession = request.getHttpSession()) != null) {
            userProperties.put("session", httpSession);
        }
        if ((userPrincipal = request.getUserPrincipal()) != null) {
            userProperties.put("userPrincipal", userPrincipal);
        }
    }

    protected Elide buildElide(DataStore store, EntityDictionary dictionary) {
        GraphQLSettings.GraphQLSettingsBuilder graphqlSettings = GraphQLSettings.GraphQLSettingsBuilder.withDefaults((EntityDictionary)dictionary);
        ElideSettings.ElideSettingsBuilder builder = (ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)ElideSettings.builder().dataStore(store)).baseUrl(this.baseUrl)).settings(new Settings.SettingsBuilder[]{graphqlSettings})).entityDictionary(dictionary)).serdes(serdes -> serdes.withISO8601Dates("yyyy-MM-dd'T'HH:mm'Z'", Calendar.getInstance().getTimeZone()));
        if (this.elideSettingsBuilderCustomizer != null) {
            this.elideSettingsBuilderCustomizer.customize(builder);
        }
        Elide elide = new Elide(builder.build());
        elide.doScans();
        return elide;
    }

    protected DataStore buildDataStore(EntityDictionary dictionary) {
        return new JMSDataStore(dictionary.getScanner(), this.connectionFactory, dictionary, null);
    }

    protected SubscriptionWebSocket buildWebSocket(Elide elide) {
        elide.getObjectMapper().registerModule((Module)new GraphQLModule());
        return SubscriptionWebSocket.builder().elide(elide).connectionTimeout(this.connectionTimeout).maxSubscriptions(this.maxSubscriptions).maxMessageSize(this.maxMessageSize).maxIdleTimeout(this.maxIdleTimeout).userFactory(this.userFactory).sendPingOnSubscribe(this.sendPingOnSubscribe).dataFetcherExceptionHandler(this.dataFetcherExceptionHandler).routeResolver(this.routeResolver).build();
    }

    private static ElideSettingsBuilderCustomizer $default$elideSettingsBuilderCustomizer() {
        return null;
    }

    private static String $default$baseUrl() {
        return "/";
    }

    private static Duration $default$connectionTimeout() {
        return Duration.ofMillis(5000L);
    }

    private static int $default$maxSubscriptions() {
        return 30;
    }

    private static Duration $default$maxIdleTimeout() {
        return Duration.ofMillis(300000L);
    }

    private static int $default$maxMessageSize() {
        return 10000;
    }

    private static SubscriptionWebSocket.UserFactory $default$userFactory() {
        return SubscriptionWebSocket.DEFAULT_USER_FACTORY;
    }

    private static boolean $default$sendPingOnSubscribe() {
        return false;
    }

    private static DataFetcherExceptionHandler $default$dataFetcherExceptionHandler() {
        return new SimpleDataFetcherExceptionHandler();
    }

    private static RouteResolver $default$routeResolver() {
        return null;
    }

    private static Injector $default$injector() {
        return null;
    }

    public static SubscriptionWebSocketConfiguratorBuilder builder() {
        return new SubscriptionWebSocketConfiguratorBuilder();
    }

    protected SubscriptionWebSocketConfigurator(ConnectionFactory connectionFactory, ElideSettingsBuilderCustomizer elideSettingsBuilderCustomizer, String baseUrl, Duration connectionTimeout, int maxSubscriptions, Duration maxIdleTimeout, int maxMessageSize, SubscriptionWebSocket.UserFactory userFactory, boolean sendPingOnSubscribe, DataFetcherExceptionHandler dataFetcherExceptionHandler, RouteResolver routeResolver, Injector injector) {
        this.connectionFactory = connectionFactory;
        this.elideSettingsBuilderCustomizer = elideSettingsBuilderCustomizer;
        this.baseUrl = baseUrl;
        this.connectionTimeout = connectionTimeout;
        this.maxSubscriptions = maxSubscriptions;
        this.maxIdleTimeout = maxIdleTimeout;
        this.maxMessageSize = maxMessageSize;
        this.userFactory = userFactory;
        this.sendPingOnSubscribe = sendPingOnSubscribe;
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
        this.routeResolver = routeResolver;
        this.injector = injector;
    }

    public static class SubscriptionWebSocketConfiguratorBuilder {
        private ConnectionFactory connectionFactory;
        private boolean elideSettingsBuilderCustomizer$set;
        private ElideSettingsBuilderCustomizer elideSettingsBuilderCustomizer$value;
        private boolean baseUrl$set;
        private String baseUrl$value;
        private boolean connectionTimeout$set;
        private Duration connectionTimeout$value;
        private boolean maxSubscriptions$set;
        private int maxSubscriptions$value;
        private boolean maxIdleTimeout$set;
        private Duration maxIdleTimeout$value;
        private boolean maxMessageSize$set;
        private int maxMessageSize$value;
        private boolean userFactory$set;
        private SubscriptionWebSocket.UserFactory userFactory$value;
        private boolean sendPingOnSubscribe$set;
        private boolean sendPingOnSubscribe$value;
        private boolean dataFetcherExceptionHandler$set;
        private DataFetcherExceptionHandler dataFetcherExceptionHandler$value;
        private boolean routeResolver$set;
        private RouteResolver routeResolver$value;
        private boolean injector$set;
        private Injector injector$value;

        SubscriptionWebSocketConfiguratorBuilder() {
        }

        public SubscriptionWebSocketConfiguratorBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder elideSettingsBuilderCustomizer(ElideSettingsBuilderCustomizer elideSettingsBuilderCustomizer) {
            this.elideSettingsBuilderCustomizer$value = elideSettingsBuilderCustomizer;
            this.elideSettingsBuilderCustomizer$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder baseUrl(String baseUrl) {
            this.baseUrl$value = baseUrl;
            this.baseUrl$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout$value = connectionTimeout;
            this.connectionTimeout$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxSubscriptions(int maxSubscriptions) {
            this.maxSubscriptions$value = maxSubscriptions;
            this.maxSubscriptions$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxIdleTimeout(Duration maxIdleTimeout) {
            this.maxIdleTimeout$value = maxIdleTimeout;
            this.maxIdleTimeout$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize$value = maxMessageSize;
            this.maxMessageSize$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder userFactory(SubscriptionWebSocket.UserFactory userFactory) {
            this.userFactory$value = userFactory;
            this.userFactory$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder sendPingOnSubscribe(boolean sendPingOnSubscribe) {
            this.sendPingOnSubscribe$value = sendPingOnSubscribe;
            this.sendPingOnSubscribe$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder dataFetcherExceptionHandler(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
            this.dataFetcherExceptionHandler$value = dataFetcherExceptionHandler;
            this.dataFetcherExceptionHandler$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder routeResolver(RouteResolver routeResolver) {
            this.routeResolver$value = routeResolver;
            this.routeResolver$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder injector(Injector injector) {
            this.injector$value = injector;
            this.injector$set = true;
            return this;
        }

        public SubscriptionWebSocketConfigurator build() {
            ElideSettingsBuilderCustomizer elideSettingsBuilderCustomizer$value = this.elideSettingsBuilderCustomizer$value;
            if (!this.elideSettingsBuilderCustomizer$set) {
                elideSettingsBuilderCustomizer$value = SubscriptionWebSocketConfigurator.$default$elideSettingsBuilderCustomizer();
            }
            String baseUrl$value = this.baseUrl$value;
            if (!this.baseUrl$set) {
                baseUrl$value = SubscriptionWebSocketConfigurator.$default$baseUrl();
            }
            Duration connectionTimeout$value = this.connectionTimeout$value;
            if (!this.connectionTimeout$set) {
                connectionTimeout$value = SubscriptionWebSocketConfigurator.$default$connectionTimeout();
            }
            int maxSubscriptions$value = this.maxSubscriptions$value;
            if (!this.maxSubscriptions$set) {
                maxSubscriptions$value = SubscriptionWebSocketConfigurator.$default$maxSubscriptions();
            }
            Duration maxIdleTimeout$value = this.maxIdleTimeout$value;
            if (!this.maxIdleTimeout$set) {
                maxIdleTimeout$value = SubscriptionWebSocketConfigurator.$default$maxIdleTimeout();
            }
            int maxMessageSize$value = this.maxMessageSize$value;
            if (!this.maxMessageSize$set) {
                maxMessageSize$value = SubscriptionWebSocketConfigurator.$default$maxMessageSize();
            }
            SubscriptionWebSocket.UserFactory userFactory$value = this.userFactory$value;
            if (!this.userFactory$set) {
                userFactory$value = SubscriptionWebSocketConfigurator.$default$userFactory();
            }
            boolean sendPingOnSubscribe$value = this.sendPingOnSubscribe$value;
            if (!this.sendPingOnSubscribe$set) {
                sendPingOnSubscribe$value = SubscriptionWebSocketConfigurator.$default$sendPingOnSubscribe();
            }
            DataFetcherExceptionHandler dataFetcherExceptionHandler$value = this.dataFetcherExceptionHandler$value;
            if (!this.dataFetcherExceptionHandler$set) {
                dataFetcherExceptionHandler$value = SubscriptionWebSocketConfigurator.$default$dataFetcherExceptionHandler();
            }
            RouteResolver routeResolver$value = this.routeResolver$value;
            if (!this.routeResolver$set) {
                routeResolver$value = SubscriptionWebSocketConfigurator.$default$routeResolver();
            }
            Injector injector$value = this.injector$value;
            if (!this.injector$set) {
                injector$value = SubscriptionWebSocketConfigurator.$default$injector();
            }
            return new SubscriptionWebSocketConfigurator(this.connectionFactory, elideSettingsBuilderCustomizer$value, baseUrl$value, connectionTimeout$value, maxSubscriptions$value, maxIdleTimeout$value, maxMessageSize$value, userFactory$value, sendPingOnSubscribe$value, dataFetcherExceptionHandler$value, routeResolver$value, injector$value);
        }

        public String toString() {
            return "SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder(connectionFactory=" + this.connectionFactory + ", elideSettingsBuilderCustomizer$value=" + this.elideSettingsBuilderCustomizer$value + ", baseUrl$value=" + this.baseUrl$value + ", connectionTimeout$value=" + this.connectionTimeout$value + ", maxSubscriptions$value=" + this.maxSubscriptions$value + ", maxIdleTimeout$value=" + this.maxIdleTimeout$value + ", maxMessageSize$value=" + this.maxMessageSize$value + ", userFactory$value=" + this.userFactory$value + ", sendPingOnSubscribe$value=" + this.sendPingOnSubscribe$value + ", dataFetcherExceptionHandler$value=" + this.dataFetcherExceptionHandler$value + ", routeResolver$value=" + this.routeResolver$value + ", injector$value=" + this.injector$value + ")";
        }
    }
}

