/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.google.gson.Gson;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.datastores.jms.MessageDeserializer;
import com.yahoo.elide.datastores.jms.MessageIterable;
import com.yahoo.elide.graphql.subscriptions.hooks.TopicType;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Topic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSDataStoreTransaction
implements DataStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(JMSDataStoreTransaction.class);
    private JMSContext context;
    private EntityDictionary dictionary;
    private Gson gson;
    private long timeoutInMs;
    private List<JMSConsumer> consumers;

    public JMSDataStoreTransaction(JMSContext context, EntityDictionary dictionary, Gson gson, long timeoutInMs) {
        this.context = context;
        this.gson = gson;
        this.dictionary = dictionary;
        this.timeoutInMs = timeoutInMs;
        this.consumers = new ArrayList<JMSConsumer>();
    }

    public <T> void save(T entity, RequestScope scope) {
        throw new BadRequestException("Unsupported operation");
    }

    public <T> void delete(T entity, RequestScope scope) {
        throw new BadRequestException("Unsupported operation");
    }

    public void flush(RequestScope scope) {
    }

    public void commit(RequestScope scope) {
    }

    public <T> void createObject(T entity, RequestScope scope) {
        throw new BadRequestException("Unsupported operation");
    }

    public <T> DataStoreIterable<T> loadObjects(EntityProjection entityProjection, RequestScope scope) {
        TopicType topicType = this.getTopicType(entityProjection);
        String topicName = topicType.toTopicName(entityProjection.getType(), this.dictionary);
        Topic destination = this.context.createTopic(topicName);
        JMSConsumer consumer = this.context.createConsumer((Destination)destination);
        this.context.start();
        this.consumers.add(consumer);
        return new MessageIterable(consumer, this.timeoutInMs, new MessageDeserializer(entityProjection.getType(), this.gson));
    }

    public void cancel(RequestScope scope) {
        this.shutdown();
    }

    public void close() throws IOException {
        this.shutdown();
    }

    private void shutdown() {
        try {
            this.consumers.forEach(JMSConsumer::close);
            this.context.stop();
            this.context.close();
        }
        catch (JMSRuntimeException e) {
            log.debug("Exception throws while closing context: {}", (Object)e.getMessage());
        }
    }

    protected TopicType getTopicType(EntityProjection projection) {
        Set arguments = projection.getArguments();
        for (Argument argument : arguments) {
            if (!argument.getName().equals("topic")) continue;
            return (TopicType)argument.getValue();
        }
        return TopicType.CUSTOM;
    }
}

