/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.filter.visitor;

import com.yahoo.elide.core.filter.expression.FilterExpression;
import java.util.Objects;

public class FilterConstraints {
    private final FilterExpression whereExpression;
    private final FilterExpression havingExpression;

    public static FilterConstraints pureHaving(FilterExpression havingExpression) {
        return new FilterConstraints(null, Objects.requireNonNull(havingExpression, "havingExpression"));
    }

    public static FilterConstraints pureWhere(FilterExpression whereExpression) {
        return new FilterConstraints(Objects.requireNonNull(whereExpression, "whereExpression"), null);
    }

    public static FilterConstraints withWhereAndHaving(FilterExpression whereExpression, FilterExpression havingExpression) {
        return new FilterConstraints(Objects.requireNonNull(whereExpression, "whereExpression"), Objects.requireNonNull(havingExpression, "havingExpression"));
    }

    private FilterConstraints(FilterExpression whereExpression, FilterExpression havingExpression) {
        this.whereExpression = whereExpression;
        this.havingExpression = havingExpression;
    }

    public boolean isPureHaving() {
        return this.getWhereExpression() == null && this.getHavingExpression() != null;
    }

    public boolean isPureWhere() {
        return this.getWhereExpression() != null && this.getHavingExpression() == null;
    }

    public FilterExpression getWhereExpression() {
        return this.whereExpression;
    }

    public FilterExpression getHavingExpression() {
        return this.havingExpression;
    }
}

