/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation;

import com.google.common.collect.Sets;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.filter.visitor.FilterConstraints;
import com.yahoo.elide.datastores.aggregation.filter.visitor.SplitFilterExpressionVisitor;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.ImmutablePagination;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityProjectionTranslator {
    private Table queriedTable;
    private QueryEngine engine;
    private EntityProjection entityProjection;
    private Set<DimensionProjection> dimensionProjections;
    private Set<TimeDimensionProjection> timeDimensions;
    private List<MetricProjection> metrics;
    private FilterExpression whereFilter;
    private FilterExpression havingFilter;
    private Boolean bypassCache;
    private RequestScope scope;

    public EntityProjectionTranslator(QueryEngine engine, Table table, EntityProjection entityProjection, RequestScope scope, Boolean bypassCache) {
        this.engine = engine;
        this.queriedTable = table;
        this.entityProjection = entityProjection;
        this.bypassCache = bypassCache;
        this.scope = scope;
        this.dimensionProjections = this.resolveNonTimeDimensions();
        this.timeDimensions = this.resolveTimeDimensions();
        this.metrics = this.resolveMetrics();
        this.splitFilters();
        this.addHavingMetrics();
    }

    public Query getQuery() {
        Query query = Query.builder().source(this.queriedTable.toQueryable()).metricProjections(this.metrics).dimensionProjections(this.dimensionProjections).timeDimensionProjections(this.timeDimensions).whereFilter(this.whereFilter).havingFilter(this.havingFilter).sorting(this.entityProjection.getSorting()).pagination(ImmutablePagination.from(this.entityProjection.getPagination())).arguments(Argument.getArgumentMapFromArgumentSet((Set)this.entityProjection.getArguments())).bypassingCache(this.bypassCache).scope(this.scope).build();
        QueryValidator validator = this.engine.getValidator();
        validator.validate(query);
        return query;
    }

    private void splitFilters() {
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression == null) {
            this.whereFilter = null;
            this.havingFilter = null;
            return;
        }
        SplitFilterExpressionVisitor visitor = new SplitFilterExpressionVisitor(this.queriedTable);
        FilterConstraints constraints = (FilterConstraints)filterExpression.accept((FilterExpressionVisitor)visitor);
        this.whereFilter = constraints.getWhereExpression();
        this.havingFilter = constraints.getHavingExpression();
    }

    private void addHavingMetrics() {
        if (this.havingFilter == null) {
            return;
        }
        ((Collection)this.havingFilter.accept((FilterExpressionVisitor)new PredicateExtractionVisitor())).forEach(filterPredicate -> {
            String fieldName = filterPredicate.getField();
            if (this.queriedTable.getMetric(fieldName) != null && this.metrics.stream().noneMatch(metric -> metric.getName().equals(fieldName))) {
                MetricProjection havingMetric = this.engine.constructMetricProjection(this.queriedTable.getMetric(fieldName), fieldName, new HashMap<String, Argument>());
                this.metrics.add(havingMetric);
            }
        });
    }

    private Set<TimeDimensionProjection> resolveTimeDimensions() {
        return this.entityProjection.getAttributes().stream().filter(attribute -> this.queriedTable.getTimeDimension(attribute.getName()) != null).map(timeDimAttr -> {
            TimeDimension timeDim = this.queriedTable.getTimeDimension(timeDimAttr.getName());
            return this.engine.constructTimeDimensionProjection(timeDim, timeDimAttr.getAlias(), Argument.getArgumentMapFromArgumentSet((Set)timeDimAttr.getArguments()));
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<DimensionProjection> resolveNonTimeDimensions() {
        Set attributes = this.entityProjection.getAttributes().stream().filter(attribute -> this.queriedTable.getTimeDimension(attribute.getName()) == null).map(dimAttr -> {
            Dimension dimension = this.queriedTable.getDimension(dimAttr.getName());
            return dimension == null ? null : this.engine.constructDimensionProjection(dimension, dimAttr.getAlias(), Argument.getArgumentMapFromArgumentSet((Set)dimAttr.getArguments()));
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Set relationships = this.entityProjection.getRelationships().stream().map(dimAttr -> {
            Dimension dimension = this.queriedTable.getDimension(dimAttr.getName());
            return dimension == null ? null : this.engine.constructDimensionProjection(dimension, dimAttr.getAlias(), Collections.emptyMap());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return Sets.union(attributes, relationships);
    }

    private List<MetricProjection> resolveMetrics() {
        return this.entityProjection.getAttributes().stream().filter(attribute -> this.queriedTable.isMetric(attribute.getName())).map(attribute -> this.engine.constructMetricProjection(this.queriedTable.getMetric(attribute.getName()), attribute.getAlias(), Argument.getArgumentMapFromArgumentSet((Set)attribute.getArguments()))).collect(Collectors.toList());
    }
}

