/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.exceptions.UnknownEntityException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.JsonApiRequestScope;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.document.processors.PopulateMetaProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.tuple.Pair;
import reactor.core.publisher.Flux;

public class CollectionTerminalState
extends BaseState {
    private final Optional<PersistentResource<?>> parent;
    private final Optional<String> relationName;
    private final Type<?> entityClass;
    private PersistentResource<?> newObject;
    private final EntityProjection parentProjection;

    public CollectionTerminalState(Type<?> entityClass, Optional<PersistentResource<?>> parent, Optional<String> relationName, EntityProjection projection) {
        this.parentProjection = projection;
        this.parent = parent;
        this.relationName = relationName;
        this.entityClass = entityClass;
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleGet(StateContext state) {
        JsonApiDocument jsonApiDocument = new JsonApiDocument();
        JsonApiRequestScope requestScope = state.getRequestScope();
        Map<String, List<String>> queryParams = requestScope.getRoute().getParameters();
        LinkedHashSet collection = (LinkedHashSet)this.getResourceCollection(requestScope).collect(Collectors.toCollection(LinkedHashSet::new)).block();
        jsonApiDocument.setData(this.getData(collection, requestScope.getDictionary()));
        IncludedProcessor includedProcessor = new IncludedProcessor();
        includedProcessor.execute(jsonApiDocument, (RequestScope)requestScope, collection, queryParams);
        Pagination pagination = this.parentProjection.getPagination();
        if (this.parent.isPresent()) {
            pagination = this.parentProjection.getRelationship(this.relationName.orElseThrow(IllegalStateException::new)).get().getProjection().getPagination();
        }
        if (!pagination.isDefaultInstance()) {
            Boolean hasNextPage;
            Boolean hasPreviousPage;
            String endCursor;
            String startCursor;
            LinkedHashMap<String, Object> pageMetaData = new LinkedHashMap<String, Object>();
            pageMetaData.put("number", pagination.getOffset() / pagination.getLimit() + 1);
            pageMetaData.put("limit", pagination.getLimit());
            if (pagination.returnPageTotals()) {
                Long totalRecords = pagination.getPageTotals();
                pageMetaData.put("totalPages", totalRecords / (long)pagination.getLimit() + (long)(totalRecords % (long)pagination.getLimit() > 0L ? 1 : 0));
                pageMetaData.put("totalRecords", totalRecords);
            }
            if ((startCursor = pagination.getStartCursor()) != null) {
                pageMetaData.put("startCursor", startCursor);
                pageMetaData.remove("number");
            }
            if ((endCursor = pagination.getEndCursor()) != null) {
                pageMetaData.put("endCursor", endCursor);
                pageMetaData.remove("number");
            }
            if ((hasPreviousPage = pagination.getHasPreviousPage()) != null) {
                pageMetaData.put("hasPreviousPage", hasPreviousPage);
            }
            if ((hasNextPage = pagination.getHasNextPage()) != null) {
                pageMetaData.put("hasNextPage", hasNextPage);
            }
            LinkedHashMap<String, Object> allMetaData = new LinkedHashMap<String, Object>();
            allMetaData.put("page", pageMetaData);
            Meta meta = new Meta(allMetaData);
            jsonApiDocument.setMeta(meta);
        }
        PopulateMetaProcessor metaProcessor = new PopulateMetaProcessor();
        metaProcessor.execute(jsonApiDocument, (RequestScope)requestScope, collection, queryParams);
        return () -> Pair.of((Object)200, (Object)jsonApiDocument);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePost(StateContext state) {
        JsonApiRequestScope requestScope = state.getRequestScope();
        this.newObject = this.createObject(requestScope);
        this.parent.ifPresent(persistentResource -> persistentResource.addRelation(this.relationName.get(), this.newObject));
        return () -> {
            JsonApiDocument returnDoc = new JsonApiDocument();
            returnDoc.setData(new Data<Resource>(this.newObject.toResource()));
            PopulateMetaProcessor metaProcessor = new PopulateMetaProcessor();
            metaProcessor.execute(returnDoc, (RequestScope)requestScope, this.newObject, requestScope.getRoute().getParameters());
            return Pair.of((Object)201, (Object)returnDoc);
        };
    }

    private Flux<PersistentResource> getResourceCollection(RequestScope requestScope) {
        Flux<PersistentResource> collection = this.parent.isPresent() ? this.parent.get().getRelationCheckedFiltered(this.parentProjection.getRelationship(this.relationName.orElseThrow(IllegalStateException::new)).orElseThrow(IllegalStateException::new)) : PersistentResource.loadRecords(this.parentProjection, Collections.emptyList(), requestScope);
        return collection;
    }

    private Data getData(Set<PersistentResource> collection, EntityDictionary dictionary) {
        Preconditions.checkNotNull(collection);
        List resources = collection.stream().map(PersistentResource::toResource).collect(Collectors.toList());
        if (this.parent.isPresent()) {
            Type<?> parentClass = this.parent.get().getResourceType();
            String relationshipName = this.relationName.orElseThrow(IllegalStateException::new);
            RelationshipType type = dictionary.getRelationshipType(parentClass, relationshipName);
            return new Data(resources, type);
        }
        return new Data(resources);
    }

    private PersistentResource createObject(JsonApiRequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Map<String, Relationship> relationships;
        Resource resource;
        JsonApiDocument doc = requestScope.getJsonApiDocument();
        JsonApiMapper mapper = requestScope.getMapper();
        if (doc.getData() == null) {
            throw new InvalidEntityBodyException("Invalid JSON-API document: " + doc);
        }
        Data<Resource> data = doc.getData();
        Collection<Resource> resources = data.get();
        Resource resource2 = resource = resources.size() == 1 ? (Resource)IterableUtils.first(resources) : null;
        if (resource == null) {
            try {
                throw new InvalidEntityBodyException(mapper.writeJsonApiDocument(doc));
            }
            catch (JsonProcessingException e) {
                throw new InternalServerErrorException(e);
            }
        }
        String id = resource.getId();
        Type<?> newObjectClass = requestScope.getDictionary().getEntityClass(resource.getType(), requestScope.getRoute().getApiVersion());
        if (newObjectClass == null) {
            throw new UnknownEntityException("Entity " + resource.getType() + " not found");
        }
        if (!this.entityClass.isAssignableFrom(newObjectClass)) {
            throw new InvalidValueException((Object)("Cannot assign value of type: " + resource.getType() + " to type: " + this.entityClass));
        }
        PersistentResource<?> pResource = PersistentResource.createObject(this.parent.orElse(null), this.relationName.orElse(null), newObjectClass, requestScope, Optional.ofNullable(id));
        Map<String, Object> attributes = resource.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String fieldName = entry.getKey();
                Object val = entry.getValue();
                pResource.updateAttribute(fieldName, val);
            }
        }
        if ((relationships = resource.getRelationships()) != null) {
            for (Map.Entry<String, Relationship> entry : relationships.entrySet()) {
                String fieldName = entry.getKey();
                Relationship relationship = entry.getValue();
                Set<PersistentResource> resourceSet = relationship == null ? null : relationship.toPersistentResources(requestScope);
                pResource.updateRelation(fieldName, resourceSet);
            }
        }
        return pResource;
    }

    @Generated
    public String toString() {
        return "CollectionTerminalState(parent=" + this.parent + ", relationName=" + this.relationName + ", entityClass=" + this.entityClass + ", newObject=" + this.newObject + ", parentProjection=" + this.parentProjection + ")";
    }
}

