/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.serialization.DataDeserializer;
import com.yahoo.elide.jsonapi.serialization.DataSerializer;
import java.util.Collection;
import java.util.Comparator;
import lombok.Generated;
import reactor.core.publisher.Flux;

@JsonSerialize(using=DataSerializer.class)
@JsonDeserialize(using=DataDeserializer.class)
public class Data<T> {
    private Flux<T> values;
    private final RelationshipType relationshipType;

    public Data(T value) {
        this.values = value == null ? Flux.empty() : Flux.just(value);
        this.relationshipType = RelationshipType.MANY_TO_ONE;
    }

    public Data(Flux<T> values) {
        this(values, RelationshipType.MANY_TO_MANY);
    }

    public Data(Flux<T> values, RelationshipType relationshipType) {
        this.values = values;
        this.relationshipType = relationshipType;
    }

    public Data(Collection<T> values) {
        this(values, RelationshipType.MANY_TO_MANY);
    }

    public Data(Collection<T> values, RelationshipType relationshipType) {
        this.values = Flux.fromIterable(values);
        this.relationshipType = relationshipType;
    }

    public void sort(Comparator<T> sortFunction) {
        this.values = this.values.sort(sortFunction);
    }

    public Collection<T> get() {
        return (Collection)this.values.collectList().block();
    }

    public boolean isToOne() {
        return this.relationshipType.isToOne();
    }

    public T getSingleValue() {
        if (this.isToOne()) {
            return (T)this.values.singleOrEmpty().block();
        }
        throw new IllegalAccessError("Data is not toOne");
    }

    public Collection<ResourceIdentifier> toResourceIdentifiers() {
        return (Collection)this.values.map(object -> object != null ? ((Resource)object).toResourceIdentifier() : null).collectList().block();
    }

    @Generated
    public String toString() {
        return "Data(values=" + this.values + ", relationshipType=" + this.relationshipType + ")";
    }
}

