/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.yahoo.elide.Settings;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BasicExceptionMappers;
import com.yahoo.elide.core.exceptions.Slf4jExceptionLogger;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.DefaultFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.jsonapi.DefaultJsonApiErrorMapper;
import com.yahoo.elide.jsonapi.DefaultJsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.JsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.links.JsonApiLinks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;

public class JsonApiSettings
implements Settings {
    private final boolean enabled;
    private final String path;
    private final JsonApiMapper jsonApiMapper;
    private final Links links;
    private final int updateStatusCode;
    private final boolean strictQueryParameters;
    private final List<JoinFilterDialect> joinFilterDialects;
    private final List<SubqueryFilterDialect> subqueryFilterDialects;
    private final JsonApiExceptionHandler jsonApiExceptionHandler;

    public JsonApiSettings(boolean enabled, String path, JsonApiMapper jsonApiMapper, Links links, int updateStatusCode, boolean strictQueryParameters, List<JoinFilterDialect> joinFilterDialects, List<SubqueryFilterDialect> subqueryFilterDialects, JsonApiExceptionHandler jsonApiExceptionHandler) {
        this.enabled = enabled;
        this.path = path;
        this.jsonApiMapper = jsonApiMapper;
        this.links = links;
        this.updateStatusCode = updateStatusCode;
        this.strictQueryParameters = strictQueryParameters;
        this.joinFilterDialects = joinFilterDialects;
        this.subqueryFilterDialects = subqueryFilterDialects;
        this.jsonApiExceptionHandler = jsonApiExceptionHandler;
    }

    @Override
    public JsonApiSettingsBuilder mutate() {
        JsonApiSettingsBuilder builder = (JsonApiSettingsBuilder)((JsonApiSettingsBuilder)((JsonApiSettingsBuilder)((JsonApiSettingsBuilder)((JsonApiSettingsBuilder)((JsonApiSettingsBuilder)new JsonApiSettingsBuilder().enabled(this.enabled)).path(this.path)).jsonApiMapper(this.jsonApiMapper)).links(newLinks -> newLinks.enabled(this.getLinks().isEnabled()).jsonApiLinks(this.getLinks().getJsonApiLinks()))).strictQueryParameters(this.isStrictQueryParameters())).jsonApiExceptionHandler(this.jsonApiExceptionHandler);
        builder.updateStatusCode = this.updateStatusCode;
        builder.joinFilterDialects.addAll(this.joinFilterDialects);
        builder.subqueryFilterDialects.addAll(this.subqueryFilterDialects);
        return builder;
    }

    public static JsonApiSettingsBuilder builder() {
        return new JsonApiSettingsBuilder();
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public JsonApiMapper getJsonApiMapper() {
        return this.jsonApiMapper;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public int getUpdateStatusCode() {
        return this.updateStatusCode;
    }

    @Generated
    public boolean isStrictQueryParameters() {
        return this.strictQueryParameters;
    }

    @Generated
    public List<JoinFilterDialect> getJoinFilterDialects() {
        return this.joinFilterDialects;
    }

    @Generated
    public List<SubqueryFilterDialect> getSubqueryFilterDialects() {
        return this.subqueryFilterDialects;
    }

    @Generated
    public JsonApiExceptionHandler getJsonApiExceptionHandler() {
        return this.jsonApiExceptionHandler;
    }

    public static class Links {
        private final boolean enabled;
        private final JsonApiLinks jsonApiLinks;

        public Links(boolean enabled, JsonApiLinks jsonApiLinks) {
            this.enabled = enabled;
            this.jsonApiLinks = jsonApiLinks;
        }

        public static LinksBuilder builder() {
            return new LinksBuilder();
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public JsonApiLinks getJsonApiLinks() {
            return this.jsonApiLinks;
        }

        public static class LinksBuilder {
            private boolean enabled = false;
            private JsonApiLinks jsonApiLinks;

            public LinksBuilder enabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public LinksBuilder jsonApiLinks(JsonApiLinks jsonApiLinks) {
                this.jsonApiLinks = jsonApiLinks;
                return this;
            }

            public Links build() {
                return new Links(this.enabled, this.jsonApiLinks);
            }
        }
    }

    public static class JsonApiSettingsBuilder
    extends JsonApiSettingsBuilderSupport<JsonApiSettingsBuilder> {
        private Consumer<JsonApiSettingsBuilder> processor = null;

        private JsonApiSettingsBuilder processor(Consumer<JsonApiSettingsBuilder> processor) {
            this.processor = processor;
            return this.self();
        }

        @Override
        public JsonApiSettings build() {
            if (this.processor != null) {
                this.processor.accept(this);
            }
            return new JsonApiSettings(this.enabled, this.path, this.jsonApiMapper, this.links.build(), this.updateStatusCode, this.strictQueryParameters, this.joinFilterDialects, this.subqueryFilterDialects, this.jsonApiExceptionHandler);
        }

        @Override
        protected JsonApiSettingsBuilder self() {
            return this;
        }

        public static JsonApiSettingsBuilder withDefaults(EntityDictionary entityDictionary) {
            return new JsonApiSettingsBuilder().processor(builder -> {
                if (builder.joinFilterDialects.isEmpty()) {
                    ((JsonApiSettingsBuilder)builder.joinFilterDialect(new DefaultFilterDialect(entityDictionary))).joinFilterDialect(RSQLFilterDialect.builder().dictionary(entityDictionary).build());
                }
                if (builder.subqueryFilterDialects.isEmpty()) {
                    ((JsonApiSettingsBuilder)builder.subqueryFilterDialect(new DefaultFilterDialect(entityDictionary))).subqueryFilterDialect(RSQLFilterDialect.builder().dictionary(entityDictionary).build());
                }
            });
        }
    }

    public static abstract class JsonApiSettingsBuilderSupport<S>
    implements Settings.SettingsBuilder {
        protected boolean enabled = false;
        protected String path = "/";
        protected JsonApiMapper jsonApiMapper = new JsonApiMapper();
        protected Links.LinksBuilder links = Links.builder();
        protected int updateStatusCode = 204;
        protected boolean strictQueryParameters = true;
        protected List<JoinFilterDialect> joinFilterDialects = new ArrayList<JoinFilterDialect>();
        protected List<SubqueryFilterDialect> subqueryFilterDialects = new ArrayList<SubqueryFilterDialect>();
        protected JsonApiExceptionHandler jsonApiExceptionHandler = new DefaultJsonApiExceptionHandler(new Slf4jExceptionLogger(), BasicExceptionMappers.builder().build(), new DefaultJsonApiErrorMapper());

        protected abstract S self();

        public S enabled(boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public S path(String path) {
            this.path = path;
            return this.self();
        }

        public S jsonApiMapper(JsonApiMapper jsonApiMapper) {
            this.jsonApiMapper = jsonApiMapper;
            return this.self();
        }

        public S links(Consumer<Links.LinksBuilder> links) {
            links.accept(this.links);
            return this.self();
        }

        public S strictQueryParameters(boolean strictQueryParameters) {
            this.strictQueryParameters = strictQueryParameters;
            return this.self();
        }

        public S updateStatus200() {
            this.updateStatusCode = 200;
            return this.self();
        }

        public S updateStatus204() {
            this.updateStatusCode = 204;
            return this.self();
        }

        public S joinFilterDialects(List<JoinFilterDialect> joinFilterDialects) {
            this.joinFilterDialects = joinFilterDialects;
            return this.self();
        }

        public S joinFilterDialect(JoinFilterDialect joinFilterDialect) {
            this.joinFilterDialects.add(joinFilterDialect);
            return this.self();
        }

        public S joinFilterDialects(Consumer<List<JoinFilterDialect>> joinFilterDialects) {
            joinFilterDialects.accept(this.joinFilterDialects);
            return this.self();
        }

        public S subqueryFilterDialects(List<SubqueryFilterDialect> subqueryFilterDialects) {
            this.subqueryFilterDialects = subqueryFilterDialects;
            return this.self();
        }

        public S subqueryFilterDialect(SubqueryFilterDialect subqueryFilterDialect) {
            this.subqueryFilterDialects.add(subqueryFilterDialect);
            return this.self();
        }

        public S subqueryFilterDialects(Consumer<List<SubqueryFilterDialect>> subqueryFilterDialects) {
            subqueryFilterDialects.accept(this.subqueryFilterDialects);
            return this.self();
        }

        public S jsonApiExceptionHandler(JsonApiExceptionHandler jsonApiExceptionHandler) {
            this.jsonApiExceptionHandler = jsonApiExceptionHandler;
            return this.self();
        }
    }
}

