/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils;

import com.yahoo.elide.core.type.AccessibleObject;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.Method;
import com.yahoo.elide.core.type.Type;

public class ObjectCloners {
    private ObjectCloners() {
    }

    public static <T> T clone(T source) {
        return ObjectCloners.clone(source, ClassType.of(source.getClass()));
    }

    public static <T> T clone(T source, Type<?> cls) {
        try {
            Object target = cls.newInstance();
            ObjectCloners.copyProperties(source, target, cls);
            return (T)target;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            return source;
        }
    }

    public static void copyProperties(Object source, Object target, Type<?> cls) {
        for (Field field : cls.getFields()) {
            try {
                field.set(target, field.get(source));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                // empty catch block
            }
        }
        for (Field field : cls.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(target, field.get(source));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            if (!accessibleObject.getName().startsWith("set")) continue;
            try {
                Method getMethod = cls.getMethod("get" + accessibleObject.getName().substring(3), new Type[0]);
                accessibleObject.invoke(target, getMethod.invoke(source, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                try {
                    Method isMethod = cls.getMethod("is" + accessibleObject.getName().substring(3), new Type[0]);
                    accessibleObject.invoke(target, isMethod.invoke(source, new Object[0]));
                }
                catch (IllegalArgumentException | IllegalStateException | ReflectiveOperationException | SecurityException exception) {}
            }
            catch (IllegalArgumentException | IllegalStateException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
    }
}

