/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.type;

import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.MethodType;
import com.yahoo.elide.core.type.Type;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Executable;
import java.util.Optional;
import lombok.Generated;

public class EntityMethodType
extends MethodType {
    Type<?> targetEntity = null;
    boolean toMany = false;

    public EntityMethodType(Executable method) {
        super(method);
        Class entityType = null;
        if (method.isAnnotationPresent(ManyToMany.class)) {
            entityType = method.getAnnotation(ManyToMany.class).targetEntity();
            this.toMany = true;
        } else if (method.isAnnotationPresent(OneToMany.class)) {
            entityType = method.getAnnotation(OneToMany.class).targetEntity();
            this.toMany = true;
        } else if (method.isAnnotationPresent(OneToOne.class)) {
            entityType = method.getAnnotation(OneToOne.class).targetEntity();
        } else if (method.isAnnotationPresent(ManyToOne.class)) {
            entityType = method.getAnnotation(ManyToOne.class).targetEntity();
        }
        this.targetEntity = entityType == null || entityType.equals(Void.TYPE) ? null : ClassType.of(entityType);
    }

    @Override
    public Type<?> getParameterizedReturnType(Type<?> parentType, Optional<Integer> index) {
        if (this.targetEntity != null) {
            return this.targetEntity;
        }
        return super.getParameterizedReturnType(parentType, index);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityMethodType)) {
            return false;
        }
        EntityMethodType other = (EntityMethodType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.toMany != other.toMany) {
            return false;
        }
        Type<?> this$targetEntity = this.targetEntity;
        Type<?> other$targetEntity = other.targetEntity;
        return !(this$targetEntity == null ? other$targetEntity != null : !this$targetEntity.equals(other$targetEntity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityMethodType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.toMany ? 79 : 97);
        Type<?> $targetEntity = this.targetEntity;
        result = result * 59 + ($targetEntity == null ? 43 : $targetEntity.hashCode());
        return result;
    }
}

