/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.executors;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class MultiplexPermissionExecutor
implements PermissionExecutor {
    private Map<Type<?>, PermissionExecutor> permissionExecutorMap;
    private PermissionExecutor defaultPermissionExecutor;
    private EntityDictionary dictionary;

    public PermissionExecutor getPermissionExecutor(Type<?> cls) {
        return this.permissionExecutorMap.getOrDefault(this.dictionary.lookupBoundClass(cls), this.defaultPermissionExecutor);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource, Set<String> requestedFields) {
        return this.getPermissionExecutor(resource.getResourceType()).checkPermission(annotationClass, resource, requestedFields);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissions(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        return this.getPermissionExecutor(resource.getResourceType()).checkSpecificFieldPermissions(resource, changeSpec, annotationClass, field);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissionsDeferred(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        return this.getPermissionExecutor(resource.getResourceType()).checkSpecificFieldPermissionsDeferred(resource, changeSpec, annotationClass, field);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields) {
        return this.getPermissionExecutor(resourceClass).checkUserPermissions(resourceClass, annotationClass, requestedFields);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, String field) {
        return this.getPermissionExecutor(resourceClass).checkUserPermissions(resourceClass, annotationClass, field);
    }

    @Override
    public Optional<FilterExpression> getReadPermissionFilter(Type<?> resourceClass, Set<String> requestedFields) {
        return this.getPermissionExecutor(resourceClass).getReadPermissionFilter(resourceClass, requestedFields);
    }

    @Override
    public void executeCommitChecks() {
        this.defaultPermissionExecutor.executeCommitChecks();
        this.permissionExecutorMap.values().forEach(PermissionExecutor::executeCommitChecks);
    }

    @Override
    public void logCheckStats() {
        this.defaultPermissionExecutor.logCheckStats();
        this.permissionExecutorMap.values().forEach(PermissionExecutor::logCheckStats);
    }

    @Override
    public ExpressionResult evaluateFilterJoinUserChecks(PersistentResource<?> resource, FilterPredicate filterPredicate) {
        return this.getPermissionExecutor(resource.getResourceType()).evaluateFilterJoinUserChecks(resource, filterPredicate);
    }

    @Override
    public ExpressionResult handleFilterJoinReject(FilterPredicate filterPredicate, Path.PathElement pathElement, ForbiddenAccessException reason) {
        return this.getPermissionExecutor(pathElement.getType()).handleFilterJoinReject(filterPredicate, pathElement, reason);
    }

    @Generated
    public MultiplexPermissionExecutor(Map<Type<?>, PermissionExecutor> permissionExecutorMap, PermissionExecutor defaultPermissionExecutor, EntityDictionary dictionary) {
        this.permissionExecutorMap = permissionExecutorMap;
        this.defaultPermissionExecutor = defaultPermissionExecutor;
        this.dictionary = dictionary;
    }
}

