/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.executors;

import com.google.common.collect.ImmutableSet;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.ExpressionResultCache;
import com.yahoo.elide.core.security.permissions.PermissionExpressionBuilder;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;

public abstract class AbstractPermissionExecutor
implements PermissionExecutor {
    private final Logger log;
    protected final Queue<QueuedCheck> commitCheckQueue = new LinkedBlockingQueue<QueuedCheck>();
    protected final RequestScope requestScope;
    protected final PermissionExpressionBuilder expressionBuilder;
    protected final Map<Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>, ExpressionResult> userPermissionCheckCache;
    protected final Map<String, Long> checkStats;

    public AbstractPermissionExecutor(Logger log, RequestScope requestScope) {
        ExpressionResultCache cache = new ExpressionResultCache();
        this.log = log;
        this.requestScope = requestScope;
        this.expressionBuilder = new PermissionExpressionBuilder(cache, requestScope.getDictionary());
        this.userPermissionCheckCache = new HashMap<Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>, ExpressionResult>();
        this.checkStats = new HashMap<String, Long>();
    }

    @Override
    public void executeCommitChecks() {
        this.commitCheckQueue.forEach(expr -> {
            Expression expression = expr.getExpression();
            ExpressionResult result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
            if (result == ExpressionResult.FAIL) {
                ForbiddenAccessException e = new ForbiddenAccessException(expr.getAnnotationClass(), expression, Expression.EvaluationMode.ALL_CHECKS);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("{}", (Object)e.getLoggedMessage());
                }
                throw e;
            }
        });
        this.commitCheckQueue.clear();
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier, Optional<Function<Expression, ExpressionResult>> expressionExecutor) {
        ImmutableSet immutableFields = fields == null ? null : ImmutableSet.copyOf(fields);
        ExpressionResult expressionResult = this.userPermissionCheckCache.get(Triple.of(annotationClass, resourceClass, (Object)immutableFields));
        if (expressionResult == ExpressionResult.PASS) {
            return expressionResult;
        }
        Expression expression = expressionSupplier.get();
        if (expressionResult == null) {
            expressionResult = this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
            this.userPermissionCheckCache.put((Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>)Triple.of(annotationClass, resourceClass, (Object)immutableFields), expressionResult);
            if (expressionResult == ExpressionResult.PASS) {
                return expressionResult;
            }
        }
        return expressionExecutor.map(executor -> (ExpressionResult)((Object)((Object)executor.apply(expression)))).orElse(expressionResult);
    }

    protected <A extends Annotation> ExpressionResult checkOnlyUserPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier) {
        return this.checkPermissions(resourceClass, annotationClass, fields, expressionSupplier, Optional.empty());
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier, Function<Expression, ExpressionResult> expressionExecutor) {
        return this.checkPermissions(resourceClass, annotationClass, fields, expressionSupplier, Optional.of(expressionExecutor));
    }

    protected ExpressionResult executeExpressions(Expression expression, Class<? extends Annotation> annotationClass, Expression.EvaluationMode mode) {
        ForbiddenAccessException e;
        ExpressionResult result = expression.evaluate(mode);
        if (this.log.isTraceEnabled()) {
            String checkKey = expression.toString();
            Long checkOccurrences = this.checkStats.getOrDefault(checkKey, 0L) + 1L;
            this.checkStats.put(checkKey, checkOccurrences);
        }
        if (result == ExpressionResult.DEFERRED) {
            if (mode == Expression.EvaluationMode.USER_CHECKS_ONLY) {
                return ExpressionResult.DEFERRED;
            }
            if (this.isInlineOnlyCheck(annotationClass)) {
                result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
                if (result == ExpressionResult.FAIL) {
                    e = new ForbiddenAccessException(annotationClass, expression, Expression.EvaluationMode.ALL_CHECKS);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{}", (Object)e.getLoggedMessage());
                    }
                    throw e;
                }
                return result;
            }
            this.commitCheckQueue.add(new QueuedCheck(expression, annotationClass));
            return ExpressionResult.DEFERRED;
        }
        if (result == ExpressionResult.FAIL) {
            e = new ForbiddenAccessException(annotationClass, expression, mode);
            if (this.log.isTraceEnabled()) {
                this.log.trace("{}", (Object)e.getLoggedMessage());
            }
            throw e;
        }
        return result;
    }

    private boolean isInlineOnlyCheck(Class<? extends Annotation> annotationClass) {
        return ReadPermission.class.isAssignableFrom(annotationClass) || DeletePermission.class.isAssignableFrom(annotationClass);
    }

    private static class QueuedCheck {
        private final Expression expression;
        private final Class<? extends Annotation> annotationClass;

        @Generated
        public QueuedCheck(Expression expression, Class<? extends Annotation> annotationClass) {
            this.expression = expression;
            this.annotationClass = annotationClass;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

