/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MediaTypeParameterRouteResolver
implements RouteResolver {
    private final Function<String, String> resolver;

    public MediaTypeParameterRouteResolver(Function<String, String> resolver) {
        this.resolver = resolver;
    }

    @Override
    public Route resolve(String mediaType, String baseUrl, String path, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        List<String> acceptHeader = headers.get("accept");
        if (acceptHeader != null) {
            for (String accept : acceptHeader) {
                String apiVersion = this.fromHeader(accept, mediaType);
                if (apiVersion == null) continue;
                return Route.builder().apiVersion(apiVersion).baseUrl(baseUrl).path(path).headers(headers).parameters(parameters).build();
            }
        }
        return Route.builder().apiVersion("").baseUrl(baseUrl).path(path).headers(headers).parameters(parameters).build();
    }

    protected boolean supports(String acceptHeaderValue, String mediaType) {
        return true;
    }

    protected String fromHeader(String acceptHeaderValue, String mediaType) {
        if (this.supports(acceptHeaderValue, mediaType)) {
            String[] parameters = acceptHeaderValue.split(";");
            for (int x = 1; x < parameters.length; ++x) {
                String parameter = parameters[x].trim();
                String apiVersion = this.fromMediaTypeParameter(parameter);
                if (apiVersion == null || apiVersion.isBlank()) continue;
                return apiVersion;
            }
        }
        return null;
    }

    protected String fromMediaTypeParameter(String parameter) {
        return this.resolver.apply(parameter);
    }
}

