/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request;

import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class EntityProjection {
    @NonNull
    private Type<?> type;
    private Set<Attribute> attributes;
    private Set<Relationship> relationships;
    private FilterExpression filterExpression;
    private Sorting sorting;
    private Pagination pagination;
    private Set<Argument> arguments;

    public Set<String> getRequestedFields() {
        return Streams.concat((Stream[])new Stream[]{this.attributes.stream().map(Attribute::getName), this.relationships.stream().map(Relationship::getName)}).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public EntityProjectionBuilder copyOf() {
        return EntityProjection.builder().type(this.type).attributes(new LinkedHashSet<Attribute>(this.attributes)).relationships(new LinkedHashSet<Relationship>(this.relationships)).filterExpression(this.filterExpression).sorting(this.sorting).pagination(this.pagination).arguments(new LinkedHashSet<Argument>(this.arguments));
    }

    public Set<String> getIncludedRelationsName() {
        return this.getRelationships().stream().map(relationship -> relationship.getName()).collect(Collectors.toSet());
    }

    public Optional<Relationship> getRelationship(String name) {
        return this.relationships.stream().filter(relationship -> relationship.getName().equalsIgnoreCase(name)).findFirst();
    }

    public Optional<Relationship> getRelationship(String name, String alias) {
        return this.relationships.stream().filter(relationship -> relationship.getName().equalsIgnoreCase(name)).filter(relationship -> relationship.getAlias().equalsIgnoreCase(alias)).findFirst();
    }

    public EntityProjection merge(EntityProjection toMerge) {
        EntityProjectionBuilder merged = this.copyOf();
        for (Relationship relationship : toMerge.getRelationships()) {
            EntityProjection theirs = relationship.getProjection();
            Relationship ourRelationship = this.getRelationship(relationship.getName(), relationship.getAlias()).orElse(null);
            if (ourRelationship != null) {
                merged.relationships.remove(ourRelationship);
                merged.relationships.add(Relationship.builder().name(relationship.getName()).alias(relationship.getAlias()).projection(ourRelationship.getProjection().merge(theirs)).build());
                continue;
            }
            merged.relationships.add(relationship);
        }
        if (toMerge.getPagination() != null) {
            merged.pagination = toMerge.getPagination();
        }
        if (toMerge.getSorting() != null) {
            merged.sorting = toMerge.getSorting();
        }
        if (toMerge.getFilterExpression() != null) {
            merged.filterExpression = toMerge.getFilterExpression();
        }
        merged.attributes.addAll(toMerge.attributes);
        merged.arguments.addAll(toMerge.arguments);
        return merged.build();
    }

    @Generated
    public static EntityProjectionBuilder builder() {
        return new EntityProjectionBuilder();
    }

    @NonNull
    @Generated
    public Type<?> getType() {
        return this.type;
    }

    @Generated
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    @Generated
    public FilterExpression getFilterExpression() {
        return this.filterExpression;
    }

    @Generated
    public Sorting getSorting() {
        return this.sorting;
    }

    @Generated
    public Pagination getPagination() {
        return this.pagination;
    }

    @Generated
    public Set<Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public void setType(@NonNull Type<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setRelationships(Set<Relationship> relationships) {
        this.relationships = relationships;
    }

    @Generated
    public void setFilterExpression(FilterExpression filterExpression) {
        this.filterExpression = filterExpression;
    }

    @Generated
    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    @Generated
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    @Generated
    public void setArguments(Set<Argument> arguments) {
        this.arguments = arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityProjection)) {
            return false;
        }
        EntityProjection other = (EntityProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type<?> this$type = this.getType();
        Type<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Set<Attribute> this$attributes = this.getAttributes();
        Set<Attribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Set<Relationship> this$relationships = this.getRelationships();
        Set<Relationship> other$relationships = other.getRelationships();
        if (this$relationships == null ? other$relationships != null : !((Object)this$relationships).equals(other$relationships)) {
            return false;
        }
        FilterExpression this$filterExpression = this.getFilterExpression();
        FilterExpression other$filterExpression = other.getFilterExpression();
        if (this$filterExpression == null ? other$filterExpression != null : !this$filterExpression.equals(other$filterExpression)) {
            return false;
        }
        Sorting this$sorting = this.getSorting();
        Sorting other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !this$sorting.equals(other$sorting)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !this$pagination.equals(other$pagination)) {
            return false;
        }
        Set<Argument> this$arguments = this.getArguments();
        Set<Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityProjection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Set<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Set<Relationship> $relationships = this.getRelationships();
        result = result * 59 + ($relationships == null ? 43 : ((Object)$relationships).hashCode());
        FilterExpression $filterExpression = this.getFilterExpression();
        result = result * 59 + ($filterExpression == null ? 43 : $filterExpression.hashCode());
        Sorting $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : $sorting.hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : $pagination.hashCode());
        Set<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityProjection(type=" + this.getType() + ", attributes=" + this.getAttributes() + ", relationships=" + this.getRelationships() + ", filterExpression=" + this.getFilterExpression() + ", sorting=" + this.getSorting() + ", pagination=" + this.getPagination() + ")";
    }

    @Generated
    public EntityProjection(@NonNull Type<?> type, Set<Attribute> attributes, Set<Relationship> relationships, FilterExpression filterExpression, Sorting sorting, Pagination pagination, Set<Argument> arguments) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.attributes = attributes;
        this.relationships = relationships;
        this.filterExpression = filterExpression;
        this.sorting = sorting;
        this.pagination = pagination;
        this.arguments = arguments;
    }

    public static class EntityProjectionBuilder {
        private Type<?> type;
        private Set<Relationship> relationships = new LinkedHashSet<Relationship>();
        private Set<Attribute> attributes = new LinkedHashSet<Attribute>();
        private Set<Argument> arguments = new LinkedHashSet<Argument>();
        private FilterExpression filterExpression;
        private Sorting sorting;
        private Pagination pagination;

        public EntityProjectionBuilder type(Type<?> type) {
            this.type = type;
            return this;
        }

        public EntityProjectionBuilder type(Class<?> cls) {
            this.type = ClassType.of(cls);
            return this;
        }

        public EntityProjectionBuilder relationships(Set<Relationship> relationships) {
            this.relationships = relationships;
            return this;
        }

        public EntityProjectionBuilder attributes(Set<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public EntityProjectionBuilder arguments(Set<Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public EntityProjectionBuilder relationship(String name, EntityProjection projection) {
            return this.relationship(Relationship.builder().alias(name).name(name).projection(projection).build());
        }

        public EntityProjectionBuilder argument(Argument argument) {
            String argumentName = argument.getName();
            Argument existing = this.arguments.stream().filter(a -> a.getName().equals(argumentName)).findFirst().orElse(null);
            if (existing != null) {
                this.arguments.remove(existing);
            }
            this.arguments.add(argument);
            return this;
        }

        public EntityProjectionBuilder relationship(Relationship relationship) {
            String relationshipName = relationship.getName();
            String relationshipAlias = relationship.getAlias();
            Relationship existing = this.relationships.stream().filter(r -> r.getName().equals(relationshipName) && r.getAlias().equals(relationshipAlias)).findFirst().orElse(null);
            if (existing != null) {
                this.relationships.remove(existing);
                this.relationships.add(Relationship.builder().name(relationshipName).alias(relationshipAlias).projection(existing.getProjection().merge(relationship.getProjection())).build());
            } else {
                if (this.isAmbiguous(relationshipName, relationshipAlias)) {
                    throw new BadRequestException(String.format("Alias {%s}.{%s} is ambiguous.", this.type, relationshipAlias));
                }
                this.relationships.add(relationship);
            }
            return this;
        }

        public EntityProjectionBuilder attribute(Attribute attribute) {
            String attributeName = attribute.getName();
            String attributeAlias = attribute.getAlias();
            Attribute existing = this.attributes.stream().filter(a -> a.getName().equals(attributeName) && a.getAlias().equals(attributeAlias)).findFirst().orElse(null);
            if (existing != null) {
                this.attributes.remove(existing);
                this.attributes.add(Attribute.builder().type(attribute.getType()).name(attributeName).alias(attributeAlias).arguments((Collection<? extends Argument>)Sets.union(attribute.getArguments(), existing.getArguments())).build());
            } else {
                if (this.isAmbiguous(attributeName, attributeAlias)) {
                    throw new BadRequestException(String.format("Alias {%s}.{%s} is ambiguous.", this.type, attributeAlias));
                }
                this.attributes.add(attribute);
            }
            return this;
        }

        public Attribute getAttributeByAlias(String attributeAlias) {
            return this.attributes.stream().filter(attribute -> attribute.getAlias().equals(attributeAlias)).findAny().orElse(null);
        }

        private boolean isAmbiguous(String fieldName, String alias) {
            return this.attributes.stream().anyMatch(a -> !fieldName.equals(a.getName()) && alias.equals(a.getAlias())) || this.relationships.stream().anyMatch(r -> !fieldName.equals(r.getName()) && alias.equals(r.getAlias()));
        }

        @Generated
        EntityProjectionBuilder() {
        }

        @Generated
        public EntityProjectionBuilder filterExpression(FilterExpression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        @Generated
        public EntityProjectionBuilder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }

        @Generated
        public EntityProjectionBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        @Generated
        public EntityProjection build() {
            return new EntityProjection(this.type, this.attributes, this.relationships, this.filterExpression, this.sorting, this.pagination, this.arguments);
        }

        @Generated
        public String toString() {
            return "EntityProjection.EntityProjectionBuilder(type=" + this.type + ", attributes=" + this.attributes + ", relationships=" + this.relationships + ", filterExpression=" + this.filterExpression + ", sorting=" + this.sorting + ", pagination=" + this.pagination + ", arguments=" + this.arguments + ")";
        }

        @Generated
        public Type<?> getType() {
            return this.type;
        }

        @Generated
        public Set<Attribute> getAttributes() {
            return this.attributes;
        }

        @Generated
        public Set<Argument> getArguments() {
            return this.arguments;
        }

        @Generated
        public FilterExpression getFilterExpression() {
            return this.filterExpression;
        }

        @Generated
        public Sorting getSorting() {
            return this.sorting;
        }

        @Generated
        public Pagination getPagination() {
            return this.pagination;
        }
    }
}

