/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 3009706331255770579L;
    @NonNull
    private Type<?> type;
    @NonNull
    private String name;
    private String alias;
    private Set<Argument> arguments;

    private Attribute(@NonNull Type<?> type, @NonNull String name, String alias, Set<Argument> arguments) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.alias = alias == null ? name : alias;
        this.arguments = arguments;
    }

    @Generated
    public static AttributeBuilder builder() {
        return new AttributeBuilder();
    }

    @NonNull
    @Generated
    public Type<?> getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Set<Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public void setType(@NonNull Type<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setArguments(Set<Argument> arguments) {
        this.arguments = arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type<?> this$type = this.getType();
        Type<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Set<Argument> this$arguments = this.getArguments();
        Set<Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Attribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Set<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Attribute(name=" + this.getName() + ")";
    }

    public static class AttributeBuilder {
        @Generated
        private Type<?> type;
        @Generated
        private String name;
        @Generated
        private String alias;
        @Generated
        private ArrayList<Argument> arguments;

        public AttributeBuilder type(Type<?> type) {
            this.type = type;
            return this;
        }

        public AttributeBuilder type(Class<?> type) {
            this.type = ClassType.of(type);
            return this;
        }

        @Generated
        AttributeBuilder() {
        }

        @Generated
        public AttributeBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public AttributeBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public AttributeBuilder argument(Argument argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.add(argument);
            return this;
        }

        @Generated
        public AttributeBuilder arguments(Collection<? extends Argument> arguments) {
            if (arguments == null) {
                throw new NullPointerException("arguments cannot be null");
            }
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.addAll(arguments);
            return this;
        }

        @Generated
        public AttributeBuilder clearArguments() {
            if (this.arguments != null) {
                this.arguments.clear();
            }
            return this;
        }

        @Generated
        public Attribute build() {
            Set<Argument> arguments;
            switch (this.arguments == null ? 0 : this.arguments.size()) {
                case 0: {
                    arguments = Collections.emptySet();
                    break;
                }
                case 1: {
                    arguments = Collections.singleton(this.arguments.get(0));
                    break;
                }
                default: {
                    arguments = new LinkedHashSet(this.arguments.size() < 0x40000000 ? 1 + this.arguments.size() + (this.arguments.size() - 3) / 3 : Integer.MAX_VALUE);
                    arguments.addAll(this.arguments);
                    arguments = Collections.unmodifiableSet(arguments);
                }
            }
            return new Attribute(this.type, this.name, this.alias, arguments);
        }

        @Generated
        public String toString() {
            return "Attribute.AttributeBuilder(type=" + this.type + ", name=" + this.name + ", alias=" + this.alias + ", arguments=" + this.arguments + ")";
        }
    }
}

