/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.pagination;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.Paginate;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class PaginationImpl
implements Pagination {
    public static final String PAGE_NUMBER_KEY = "page[number]";
    public static final String PAGE_SIZE_KEY = "page[size]";
    public static final String PAGE_OFFSET_KEY = "page[offset]";
    public static final String PAGE_LIMIT_KEY = "page[limit]";
    public static final String PAGE_TOTALS_KEY = "page[totals]";
    public static final String PAGE_FIRST_KEY = "page[first]";
    public static final String PAGE_AFTER_KEY = "page[after]";
    public static final String PAGE_LAST_KEY = "page[last]";
    public static final String PAGE_BEFORE_KEY = "page[before]";
    public static final Map<String, PaginationKey> PAGE_KEYS = ImmutableMap.of((Object)"page[number]", (Object)((Object)PaginationKey.number), (Object)"page[size]", (Object)((Object)PaginationKey.size), (Object)"page[offset]", (Object)((Object)PaginationKey.offset), (Object)"page[limit]", (Object)((Object)PaginationKey.limit), (Object)"page[totals]", (Object)((Object)PaginationKey.totals), (Object)"page[first]", (Object)((Object)PaginationKey.first), (Object)"page[after]", (Object)((Object)PaginationKey.after), (Object)"page[last]", (Object)((Object)PaginationKey.last), (Object)"page[before]", (Object)((Object)PaginationKey.before));
    private Long pageTotals = null;
    private static final String PAGE_KEYS_CSV = PAGE_KEYS.keySet().stream().collect(Collectors.joining(", "));
    private final int offset;
    private final int limit;
    private final String before;
    private final String after;
    private final Pagination.Direction direction;
    private String startCursor;
    private String endCursor;
    private Boolean hasPreviousPage;
    private Boolean hasNextPage;
    private final boolean generateTotals;
    private final boolean defaultInstance;
    private final Type<?> entityClass;

    public PaginationImpl(Class<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages) {
        this(ClassType.of(entityClass), clientOffset, clientLimit, systemDefaultLimit, systemMaxLimit, generateTotals, pageByPages, null, null, null);
    }

    public PaginationImpl(Type<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages) {
        this(entityClass, clientOffset, clientLimit, systemDefaultLimit, systemMaxLimit, generateTotals, pageByPages, null, null, null);
    }

    public PaginationImpl(Class<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages, String before, String after, Pagination.Direction direction) {
        this(ClassType.of(entityClass), clientOffset, clientLimit, systemDefaultLimit, systemMaxLimit, generateTotals, pageByPages, before, after, direction);
    }

    public PaginationImpl(Type<?> entityClass, Integer clientOffset, Integer clientLimit, int systemDefaultLimit, int systemMaxLimit, Boolean generateTotals, Boolean pageByPages, String before, String after, Pagination.Direction direction) {
        String pageSizeLabel;
        Paginate paginate;
        this.entityClass = entityClass;
        this.defaultInstance = clientOffset == null && clientLimit == null && generateTotals == null && before == null && after == null;
        Paginate paginate2 = paginate = entityClass != null ? entityClass.getAnnotation(Paginate.class) : null;
        this.limit = clientLimit != null ? clientLimit : (paginate != null ? paginate.defaultPageSize() : systemDefaultLimit);
        int maxLimit = paginate != null ? paginate.maxPageSize() : systemMaxLimit;
        String string = pageSizeLabel = pageByPages != false ? "size" : "limit";
        if (this.limit > maxLimit && !this.defaultInstance) {
            throw new InvalidValueException((Object)("Pagination " + pageSizeLabel + " must be less than or equal to " + maxLimit));
        }
        if (this.limit < 1) {
            throw new InvalidValueException((Object)("Pagination " + pageSizeLabel + " must contain a positive, non-zero value."));
        }
        this.generateTotals = generateTotals != null && generateTotals != false && (paginate == null || paginate.countable());
        this.direction = direction;
        this.before = before;
        this.after = after;
        if (pageByPages.booleanValue()) {
            int pageNumber;
            int n = pageNumber = clientOffset != null ? clientOffset : 1;
            if (pageNumber < 1) {
                throw new InvalidValueException((Object)"Pagination number must be a positive, non-zero value.");
            }
            this.offset = (pageNumber - 1) * this.limit;
        } else {
            int n = this.offset = clientOffset != null ? clientOffset : 0;
            if (this.offset < 0) {
                throw new InvalidValueException((Object)"Pagination offset must contain a positive value.");
            }
        }
    }

    @Override
    public boolean returnPageTotals() {
        return this.generateTotals;
    }

    public static PaginationImpl parseQueryParams(Type<?> entityClass, Map<String, List<String>> queryParams, ElideSettings elideSettings) throws InvalidValueException {
        if (queryParams.isEmpty()) {
            return PaginationImpl.getDefaultPagination(entityClass, elideSettings);
        }
        HashMap<PaginationKey, Integer> pageData = new HashMap<PaginationKey, Integer>();
        String before = null;
        String after = null;
        Pagination.Direction direction = null;
        for (Map.Entry<String, List<String>> paramEntry : queryParams.entrySet()) {
            String queryParamKey = paramEntry.getKey();
            if (PAGE_KEYS.containsKey(queryParamKey)) {
                String value;
                PaginationKey paginationKey = PAGE_KEYS.get(queryParamKey);
                if (paginationKey.equals((Object)PaginationKey.totals)) {
                    pageData.put(paginationKey, 0);
                    continue;
                }
                if (paginationKey.equals((Object)PaginationKey.before)) {
                    before = value = paramEntry.getValue().get(0);
                    direction = Pagination.Direction.BACKWARD;
                    continue;
                }
                if (paginationKey.equals((Object)PaginationKey.after)) {
                    after = value = paramEntry.getValue().get(0);
                    direction = Pagination.Direction.FORWARD;
                    continue;
                }
                value = paramEntry.getValue().get(0);
                try {
                    int intValue = Integer.parseInt(value, 10);
                    pageData.put(paginationKey, intValue);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException((Object)"page values must be integers");
                }
            }
            if (!queryParamKey.startsWith("page[")) continue;
            throw new InvalidValueException((Object)("Invalid Pagination Parameter. Accepted values are " + PAGE_KEYS_CSV));
        }
        if (before != null && after != null) {
            direction = Pagination.Direction.BETWEEN;
        }
        return PaginationImpl.getPagination(entityClass, pageData, before, after, direction, elideSettings);
    }

    private static PaginationImpl getPagination(Type<?> entityClass, Map<PaginationKey, Integer> pageData, String before, String after, Pagination.Direction direction, ElideSettings elideSettings) {
        if (PaginationImpl.hasInvalidCombination(pageData)) {
            throw new InvalidValueException((Object)"Invalid usage of pagination parameters.");
        }
        if (pageData.containsKey((Object)PaginationKey.first) && pageData.containsKey((Object)PaginationKey.last)) {
            throw new InvalidValueException((Object)"page[first] and page[last] cannot be used together.");
        }
        if (pageData.containsKey((Object)PaginationKey.first) && direction != null) {
            throw new InvalidValueException((Object)"page[first] cannot be used together with page[before] or page[after].");
        }
        if (pageData.containsKey((Object)PaginationKey.last) && direction != null) {
            throw new InvalidValueException((Object)"page[last] cannot be used together with page[before] or page[after].");
        }
        boolean pageByPages = false;
        Integer offset = pageData.getOrDefault((Object)PaginationKey.offset, null);
        Integer limit = pageData.getOrDefault((Object)PaginationKey.limit, null);
        if (pageData.containsKey((Object)PaginationKey.size) || pageData.containsKey((Object)PaginationKey.number)) {
            pageByPages = true;
            offset = pageData.getOrDefault((Object)PaginationKey.number, null);
            limit = pageData.getOrDefault((Object)PaginationKey.size, null);
        }
        if (pageData.containsKey((Object)PaginationKey.first)) {
            direction = Pagination.Direction.FORWARD;
            limit = pageData.getOrDefault((Object)PaginationKey.first, null);
        } else if (pageData.containsKey((Object)PaginationKey.last)) {
            direction = Pagination.Direction.BACKWARD;
            limit = pageData.getOrDefault((Object)PaginationKey.last, null);
        }
        return new PaginationImpl(entityClass, offset, limit, elideSettings.getDefaultPageSize(), elideSettings.getMaxPageSize(), pageData.containsKey((Object)PaginationKey.totals) ? Boolean.valueOf(true) : null, (Boolean)pageByPages, before, after, direction);
    }

    private static boolean hasInvalidCombination(Map<PaginationKey, Integer> pageData) {
        return !(!pageData.containsKey((Object)PaginationKey.size) && !pageData.containsKey((Object)PaginationKey.number) || !pageData.containsKey((Object)PaginationKey.limit) && !pageData.containsKey((Object)PaginationKey.offset));
    }

    public static PaginationImpl getDefaultPagination(Type<?> entityClass, ElideSettings elideSettings) {
        return new PaginationImpl(entityClass, null, null, elideSettings.getDefaultPageSize(), elideSettings.getMaxPageSize(), null, (Boolean)false);
    }

    public static PaginationImpl getDefaultPagination(Type<?> entityClass) {
        return new PaginationImpl(entityClass, null, null, 500, 10000, null, (Boolean)false);
    }

    @Generated
    public String toString() {
        return "PaginationImpl(pageTotals=" + this.getPageTotals() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + ", direction=" + this.getDirection() + ", startCursor=" + this.getStartCursor() + ", endCursor=" + this.getEndCursor() + ", hasPreviousPage=" + this.getHasPreviousPage() + ", hasNextPage=" + this.getHasNextPage() + ", generateTotals=" + this.generateTotals + ", defaultInstance=" + this.isDefaultInstance() + ", entityClass=" + this.getEntityClass() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginationImpl)) {
            return false;
        }
        PaginationImpl other = (PaginationImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.generateTotals != other.generateTotals) {
            return false;
        }
        if (this.isDefaultInstance() != other.isDefaultInstance()) {
            return false;
        }
        Long this$pageTotals = this.getPageTotals();
        Long other$pageTotals = other.getPageTotals();
        if (this$pageTotals == null ? other$pageTotals != null : !((Object)this$pageTotals).equals(other$pageTotals)) {
            return false;
        }
        Boolean this$hasPreviousPage = this.getHasPreviousPage();
        Boolean other$hasPreviousPage = other.getHasPreviousPage();
        if (this$hasPreviousPage == null ? other$hasPreviousPage != null : !((Object)this$hasPreviousPage).equals(other$hasPreviousPage)) {
            return false;
        }
        Boolean this$hasNextPage = this.getHasNextPage();
        Boolean other$hasNextPage = other.getHasNextPage();
        if (this$hasNextPage == null ? other$hasNextPage != null : !((Object)this$hasNextPage).equals(other$hasNextPage)) {
            return false;
        }
        String this$before = this.getBefore();
        String other$before = other.getBefore();
        if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
            return false;
        }
        String this$after = this.getAfter();
        String other$after = other.getAfter();
        if (this$after == null ? other$after != null : !this$after.equals(other$after)) {
            return false;
        }
        Pagination.Direction this$direction = this.getDirection();
        Pagination.Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$startCursor = this.getStartCursor();
        String other$startCursor = other.getStartCursor();
        if (this$startCursor == null ? other$startCursor != null : !this$startCursor.equals(other$startCursor)) {
            return false;
        }
        String this$endCursor = this.getEndCursor();
        String other$endCursor = other.getEndCursor();
        if (this$endCursor == null ? other$endCursor != null : !this$endCursor.equals(other$endCursor)) {
            return false;
        }
        Type<?> this$entityClass = this.getEntityClass();
        Type<?> other$entityClass = other.getEntityClass();
        return !(this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaginationImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.generateTotals ? 79 : 97);
        result = result * 59 + (this.isDefaultInstance() ? 79 : 97);
        Long $pageTotals = this.getPageTotals();
        result = result * 59 + ($pageTotals == null ? 43 : ((Object)$pageTotals).hashCode());
        Boolean $hasPreviousPage = this.getHasPreviousPage();
        result = result * 59 + ($hasPreviousPage == null ? 43 : ((Object)$hasPreviousPage).hashCode());
        Boolean $hasNextPage = this.getHasNextPage();
        result = result * 59 + ($hasNextPage == null ? 43 : ((Object)$hasNextPage).hashCode());
        String $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : $before.hashCode());
        String $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : $after.hashCode());
        Pagination.Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $startCursor = this.getStartCursor();
        result = result * 59 + ($startCursor == null ? 43 : $startCursor.hashCode());
        String $endCursor = this.getEndCursor();
        result = result * 59 + ($endCursor == null ? 43 : $endCursor.hashCode());
        Type<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        return result;
    }

    @Override
    @Generated
    public Long getPageTotals() {
        return this.pageTotals;
    }

    @Override
    @Generated
    public void setPageTotals(Long pageTotals) {
        this.pageTotals = pageTotals;
    }

    @Override
    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Override
    @Generated
    public String getBefore() {
        return this.before;
    }

    @Override
    @Generated
    public String getAfter() {
        return this.after;
    }

    @Override
    @Generated
    public Pagination.Direction getDirection() {
        return this.direction;
    }

    @Override
    @Generated
    public String getStartCursor() {
        return this.startCursor;
    }

    @Override
    @Generated
    public void setStartCursor(String startCursor) {
        this.startCursor = startCursor;
    }

    @Override
    @Generated
    public String getEndCursor() {
        return this.endCursor;
    }

    @Override
    @Generated
    public void setEndCursor(String endCursor) {
        this.endCursor = endCursor;
    }

    @Override
    @Generated
    public Boolean getHasPreviousPage() {
        return this.hasPreviousPage;
    }

    @Override
    @Generated
    public void setHasPreviousPage(Boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    @Override
    @Generated
    public Boolean getHasNextPage() {
        return this.hasNextPage;
    }

    @Override
    @Generated
    public void setHasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    @Override
    @Generated
    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    @Generated
    public Type<?> getEntityClass() {
        return this.entityClass;
    }

    public static enum PaginationKey {
        offset,
        number,
        size,
        limit,
        totals,
        first,
        after,
        last,
        before;

    }
}

